/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.comparison;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Warnings;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.LessThan;

public final class LessThanDoublesEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Warnings warnings;
    private final EvalOperator.ExpressionEvaluator lhs;
    private final EvalOperator.ExpressionEvaluator rhs;
    private final DriverContext driverContext;

    public LessThanDoublesEvaluator(Source source, EvalOperator.ExpressionEvaluator lhs, EvalOperator.ExpressionEvaluator rhs, DriverContext driverContext) {
        this.lhs = lhs;
        this.rhs = rhs;
        this.driverContext = driverContext;
        this.warnings = Warnings.createWarnings(driverContext.warningsMode(), source);
    }

    public Block eval(Page page) {
        try (DoubleBlock lhsBlock = (DoubleBlock)this.lhs.eval(page);){
            BooleanBlock booleanBlock;
            block20: {
                DoubleVector rhsVector;
                DoubleVector lhsVector;
                DoubleBlock rhsBlock;
                block18: {
                    BooleanBlock booleanBlock2;
                    block19: {
                        block16: {
                            BooleanBlock booleanBlock3;
                            block17: {
                                rhsBlock = (DoubleBlock)this.rhs.eval(page);
                                try {
                                    lhsVector = lhsBlock.asVector();
                                    if (lhsVector != null) break block16;
                                    booleanBlock3 = this.eval(page.getPositionCount(), lhsBlock, rhsBlock);
                                    if (rhsBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (rhsBlock != null) {
                                        try {
                                            rhsBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                rhsBlock.close();
                            }
                            return booleanBlock3;
                        }
                        rhsVector = rhsBlock.asVector();
                        if (rhsVector != null) break block18;
                        booleanBlock2 = this.eval(page.getPositionCount(), lhsBlock, rhsBlock);
                        if (rhsBlock == null) break block19;
                        rhsBlock.close();
                    }
                    return booleanBlock2;
                }
                booleanBlock = this.eval(page.getPositionCount(), lhsVector, rhsVector).asBlock();
                if (rhsBlock == null) break block20;
                rhsBlock.close();
            }
            return booleanBlock;
        }
    }

    public BooleanBlock eval(int positionCount, DoubleBlock lhsBlock, DoubleBlock rhsBlock) {
        try (BooleanBlock.Builder result = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (lhsBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (lhsBlock.getValueCount(p) != 1) {
                    if (lhsBlock.getValueCount(p) > 1) {
                        this.warnings.registerException(new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                if (rhsBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (rhsBlock.getValueCount(p) != 1) {
                    if (rhsBlock.getValueCount(p) > 1) {
                        this.warnings.registerException(new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                result.appendBoolean(LessThan.processDoubles(lhsBlock.getDouble(lhsBlock.getFirstValueIndex(p)), rhsBlock.getDouble(rhsBlock.getFirstValueIndex(p))));
            }
            BooleanBlock booleanBlock = result.build();
            return booleanBlock;
        }
    }

    public BooleanVector eval(int positionCount, DoubleVector lhsVector, DoubleVector rhsVector) {
        try (BooleanVector.FixedBuilder result = this.driverContext.blockFactory().newBooleanVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                result.appendBoolean(p, LessThan.processDoubles(lhsVector.getDouble(p), rhsVector.getDouble(p)));
            }
            BooleanVector booleanVector = result.build();
            return booleanVector;
        }
    }

    public String toString() {
        return "LessThanDoublesEvaluator[lhs=" + this.lhs + ", rhs=" + this.rhs + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.lhs, this.rhs});
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory lhs;
        private final EvalOperator.ExpressionEvaluator.Factory rhs;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory lhs, EvalOperator.ExpressionEvaluator.Factory rhs) {
            this.source = source;
            this.lhs = lhs;
            this.rhs = rhs;
        }

        public LessThanDoublesEvaluator get(DriverContext context) {
            return new LessThanDoublesEvaluator(this.source, this.lhs.get(context), this.rhs.get(context), context);
        }

        public String toString() {
            return "LessThanDoublesEvaluator[lhs=" + this.lhs + ", rhs=" + this.rhs + "]";
        }
    }
}

