/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.comparison;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.expression.predicate.operator.comparison.Comparisons;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.StringUtils;
import org.elasticsearch.xpack.esql.expression.EsqlTypeResolutions;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;

public class In
extends org.elasticsearch.xpack.esql.core.expression.predicate.operator.comparison.In {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "In", In::new);

    @FunctionInfo(returnType={"boolean"}, description="The `IN` operator allows testing whether a field or expression equals an element in a list of literals, fields or expressions:", examples={@Example(file="row", tag="in-with-expressions")})
    public In(Source source, Expression value, List<Expression> list) {
        super(source, value, list);
    }

    private In(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), in.readNamedWriteableCollectionAsList(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.value());
        out.writeNamedWriteableCollection((Collection)this.list());
    }

    public String getWriteableName() {
        return In.ENTRY.name;
    }

    protected NodeInfo<org.elasticsearch.xpack.esql.core.expression.predicate.operator.comparison.In> info() {
        return NodeInfo.create((Node)this, In::new, (Object)this.value(), (Object)this.list());
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new In(this.source(), newChildren.get(newChildren.size() - 1), newChildren.subList(0, newChildren.size() - 1));
    }

    public boolean foldable() {
        return Expressions.isNull((Expression)this.value()) || super.foldable();
    }

    public Boolean fold() {
        if (Expressions.isNull((Expression)this.value()) || this.list().stream().allMatch(Expressions::isNull)) {
            return null;
        }
        return In.apply(this.value().fold(), this.list().stream().map(Expression::fold).toList());
    }

    private static Boolean apply(Object input, List<Object> values) {
        Boolean result = Boolean.FALSE;
        for (Object v : values) {
            Boolean compResult = Comparisons.eq((Object)input, (Object)v);
            if (compResult == null) {
                result = null;
                continue;
            }
            if (compResult != Boolean.TRUE) continue;
            return Boolean.TRUE;
        }
        return result;
    }

    protected boolean areCompatible(DataType left, DataType right) {
        if (left == DataType.UNSIGNED_LONG || right == DataType.UNSIGNED_LONG) {
            return left == right;
        }
        return EsqlDataTypes.areCompatible(left, right);
    }

    protected Expression.TypeResolution resolveType() {
        Expression.TypeResolution resolution = EsqlTypeResolutions.isExact(this.value(), this.functionName(), TypeResolutions.ParamOrdinal.DEFAULT);
        if (resolution.unresolved()) {
            return resolution;
        }
        DataType dt = this.value().dataType();
        for (int i = 0; i < this.list().size(); ++i) {
            Expression listValue = (Expression)this.list().get(i);
            if (this.areCompatible(dt, listValue.dataType())) continue;
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"{} argument of [{}] must be [{}], found value [{}] type [{}]", (Object[])new Object[]{StringUtils.ordinal((int)(i + 1)), this.sourceText(), dt.typeName(), Expressions.name((Expression)listValue), listValue.dataType().typeName()}));
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }
}

