/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.comparison;

import java.time.ZoneId;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.predicate.Negatable;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.EsqlArithmeticOperation;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.EsqlBinaryComparison;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.GreaterThanOrEqualDoublesEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.GreaterThanOrEqualIntsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.GreaterThanOrEqualKeywordsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.GreaterThanOrEqualLongsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.LessThan;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.LessThanOrEqual;

public class GreaterThanOrEqual
extends EsqlBinaryComparison
implements Negatable<EsqlBinaryComparison> {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "GreaterThanOrEqual", EsqlBinaryComparison::readFrom);
    private static final Map<DataType, EsqlArithmeticOperation.BinaryEvaluator> evaluatorMap = Map.ofEntries(Map.entry(DataType.INTEGER, GreaterThanOrEqualIntsEvaluator.Factory::new), Map.entry(DataType.DOUBLE, GreaterThanOrEqualDoublesEvaluator.Factory::new), Map.entry(DataType.LONG, GreaterThanOrEqualLongsEvaluator.Factory::new), Map.entry(DataType.UNSIGNED_LONG, GreaterThanOrEqualLongsEvaluator.Factory::new), Map.entry(DataType.DATETIME, GreaterThanOrEqualLongsEvaluator.Factory::new), Map.entry(DataType.KEYWORD, GreaterThanOrEqualKeywordsEvaluator.Factory::new), Map.entry(DataType.TEXT, GreaterThanOrEqualKeywordsEvaluator.Factory::new), Map.entry(DataType.VERSION, GreaterThanOrEqualKeywordsEvaluator.Factory::new), Map.entry(DataType.IP, GreaterThanOrEqualKeywordsEvaluator.Factory::new));

    public GreaterThanOrEqual(Source source, Expression left, Expression right) {
        super(source, left, right, EsqlBinaryComparison.BinaryComparisonOperation.GTE, evaluatorMap);
    }

    public GreaterThanOrEqual(Source source, Expression left, Expression right, ZoneId zoneId) {
        super(source, left, right, EsqlBinaryComparison.BinaryComparisonOperation.GTE, zoneId, evaluatorMap);
    }

    public String getWriteableName() {
        return GreaterThanOrEqual.ENTRY.name;
    }

    protected NodeInfo<GreaterThanOrEqual> info() {
        return NodeInfo.create((Node)this, GreaterThanOrEqual::new, (Object)this.left(), (Object)this.right(), (Object)this.zoneId());
    }

    protected GreaterThanOrEqual replaceChildren(Expression newLeft, Expression newRight) {
        return new GreaterThanOrEqual(this.source(), newLeft, newRight, this.zoneId());
    }

    public LessThanOrEqual swapLeftAndRight() {
        return new LessThanOrEqual(this.source(), this.right(), this.left(), this.zoneId());
    }

    public LessThan negate() {
        return new LessThan(this.source(), this.left(), this.right(), this.zoneId());
    }

    public EsqlBinaryComparison reverse() {
        return new LessThanOrEqual(this.source(), this.left(), this.right(), this.zoneId());
    }

    static boolean processInts(int lhs, int rhs) {
        return lhs >= rhs;
    }

    static boolean processLongs(long lhs, long rhs) {
        return lhs >= rhs;
    }

    static boolean processDoubles(double lhs, double rhs) {
        return lhs >= rhs;
    }

    static boolean processKeywords(BytesRef lhs, BytesRef rhs) {
        return lhs.compareTo(rhs) >= 0;
    }
}

