/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.comparison;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Warnings;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.GreaterThan;

public final class GreaterThanKeywordsEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Warnings warnings;
    private final EvalOperator.ExpressionEvaluator lhs;
    private final EvalOperator.ExpressionEvaluator rhs;
    private final DriverContext driverContext;

    public GreaterThanKeywordsEvaluator(Source source, EvalOperator.ExpressionEvaluator lhs, EvalOperator.ExpressionEvaluator rhs, DriverContext driverContext) {
        this.lhs = lhs;
        this.rhs = rhs;
        this.driverContext = driverContext;
        this.warnings = Warnings.createWarnings(driverContext.warningsMode(), source);
    }

    public Block eval(Page page) {
        try (BytesRefBlock lhsBlock = (BytesRefBlock)this.lhs.eval(page);){
            BooleanBlock booleanBlock;
            block20: {
                BytesRefVector rhsVector;
                BytesRefVector lhsVector;
                BytesRefBlock rhsBlock;
                block18: {
                    BooleanBlock booleanBlock2;
                    block19: {
                        block16: {
                            BooleanBlock booleanBlock3;
                            block17: {
                                rhsBlock = (BytesRefBlock)this.rhs.eval(page);
                                try {
                                    lhsVector = lhsBlock.asVector();
                                    if (lhsVector != null) break block16;
                                    booleanBlock3 = this.eval(page.getPositionCount(), lhsBlock, rhsBlock);
                                    if (rhsBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (rhsBlock != null) {
                                        try {
                                            rhsBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                rhsBlock.close();
                            }
                            return booleanBlock3;
                        }
                        rhsVector = rhsBlock.asVector();
                        if (rhsVector != null) break block18;
                        booleanBlock2 = this.eval(page.getPositionCount(), lhsBlock, rhsBlock);
                        if (rhsBlock == null) break block19;
                        rhsBlock.close();
                    }
                    return booleanBlock2;
                }
                booleanBlock = this.eval(page.getPositionCount(), lhsVector, rhsVector).asBlock();
                if (rhsBlock == null) break block20;
                rhsBlock.close();
            }
            return booleanBlock;
        }
    }

    public BooleanBlock eval(int positionCount, BytesRefBlock lhsBlock, BytesRefBlock rhsBlock) {
        try (BooleanBlock.Builder result = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);){
            BytesRef lhsScratch = new BytesRef();
            BytesRef rhsScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                if (lhsBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (lhsBlock.getValueCount(p) != 1) {
                    if (lhsBlock.getValueCount(p) > 1) {
                        this.warnings.registerException(new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                if (rhsBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (rhsBlock.getValueCount(p) != 1) {
                    if (rhsBlock.getValueCount(p) > 1) {
                        this.warnings.registerException(new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                result.appendBoolean(GreaterThan.processKeywords(lhsBlock.getBytesRef(lhsBlock.getFirstValueIndex(p), lhsScratch), rhsBlock.getBytesRef(rhsBlock.getFirstValueIndex(p), rhsScratch)));
            }
            BooleanBlock booleanBlock = result.build();
            return booleanBlock;
        }
    }

    public BooleanVector eval(int positionCount, BytesRefVector lhsVector, BytesRefVector rhsVector) {
        try (BooleanVector.FixedBuilder result = this.driverContext.blockFactory().newBooleanVectorFixedBuilder(positionCount);){
            BytesRef lhsScratch = new BytesRef();
            BytesRef rhsScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                result.appendBoolean(p, GreaterThan.processKeywords(lhsVector.getBytesRef(p, lhsScratch), rhsVector.getBytesRef(p, rhsScratch)));
            }
            BooleanVector booleanVector = result.build();
            return booleanVector;
        }
    }

    public String toString() {
        return "GreaterThanKeywordsEvaluator[lhs=" + this.lhs + ", rhs=" + this.rhs + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.lhs, this.rhs});
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory lhs;
        private final EvalOperator.ExpressionEvaluator.Factory rhs;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory lhs, EvalOperator.ExpressionEvaluator.Factory rhs) {
            this.source = source;
            this.lhs = lhs;
            this.rhs = rhs;
        }

        public GreaterThanKeywordsEvaluator get(DriverContext context) {
            return new GreaterThanKeywordsEvaluator(this.source, this.lhs.get(context), this.rhs.get(context), context);
        }

        public String toString() {
            return "GreaterThanKeywordsEvaluator[lhs=" + this.lhs + ", rhs=" + this.rhs + "]";
        }
    }
}

