/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.comparison;

import java.time.ZoneId;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.predicate.Negatable;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.EsqlArithmeticOperation;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.EqualsBoolsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.EqualsDoublesEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.EqualsGeometriesEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.EqualsIntsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.EqualsKeywordsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.EqualsLongsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.EsqlBinaryComparison;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.NotEquals;

public class Equals
extends EsqlBinaryComparison
implements Negatable<EsqlBinaryComparison> {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Equals", EsqlBinaryComparison::readFrom);
    private static final Map<DataType, EsqlArithmeticOperation.BinaryEvaluator> evaluatorMap = Map.ofEntries(Map.entry(DataType.BOOLEAN, EqualsBoolsEvaluator.Factory::new), Map.entry(DataType.INTEGER, EqualsIntsEvaluator.Factory::new), Map.entry(DataType.DOUBLE, EqualsDoublesEvaluator.Factory::new), Map.entry(DataType.LONG, EqualsLongsEvaluator.Factory::new), Map.entry(DataType.UNSIGNED_LONG, EqualsLongsEvaluator.Factory::new), Map.entry(DataType.DATETIME, EqualsLongsEvaluator.Factory::new), Map.entry(DataType.GEO_POINT, EqualsGeometriesEvaluator.Factory::new), Map.entry(DataType.CARTESIAN_POINT, EqualsGeometriesEvaluator.Factory::new), Map.entry(DataType.GEO_SHAPE, EqualsGeometriesEvaluator.Factory::new), Map.entry(DataType.CARTESIAN_SHAPE, EqualsGeometriesEvaluator.Factory::new), Map.entry(DataType.KEYWORD, EqualsKeywordsEvaluator.Factory::new), Map.entry(DataType.TEXT, EqualsKeywordsEvaluator.Factory::new), Map.entry(DataType.VERSION, EqualsKeywordsEvaluator.Factory::new), Map.entry(DataType.IP, EqualsKeywordsEvaluator.Factory::new));

    public Equals(Source source, Expression left, Expression right) {
        super(source, left, right, EsqlBinaryComparison.BinaryComparisonOperation.EQ, evaluatorMap);
    }

    public Equals(Source source, Expression left, Expression right, ZoneId zoneId) {
        super(source, left, right, EsqlBinaryComparison.BinaryComparisonOperation.EQ, zoneId, evaluatorMap);
    }

    public String getWriteableName() {
        return Equals.ENTRY.name;
    }

    protected NodeInfo<Equals> info() {
        return NodeInfo.create((Node)this, Equals::new, (Object)this.left(), (Object)this.right(), (Object)this.zoneId());
    }

    protected Equals replaceChildren(Expression newLeft, Expression newRight) {
        return new Equals(this.source(), newLeft, newRight, this.zoneId());
    }

    public Equals swapLeftAndRight() {
        return new Equals(this.source(), this.right(), this.left(), this.zoneId());
    }

    public EsqlBinaryComparison reverse() {
        return this;
    }

    public EsqlBinaryComparison negate() {
        return new NotEquals(this.source(), this.left(), this.right(), this.zoneId());
    }

    static boolean processInts(int lhs, int rhs) {
        return lhs == rhs;
    }

    static boolean processLongs(long lhs, long rhs) {
        return lhs == rhs;
    }

    static boolean processDoubles(double lhs, double rhs) {
        return lhs == rhs;
    }

    static boolean processKeywords(BytesRef lhs, BytesRef rhs) {
        return lhs.equals((Object)rhs);
    }

    static boolean processBools(boolean lhs, boolean rhs) {
        return lhs == rhs;
    }

    static boolean processGeometries(BytesRef lhs, BytesRef rhs) {
        return lhs.equals((Object)rhs);
    }
}

