/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic;

import java.time.DateTimeException;
import java.time.temporal.TemporalAmount;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Warnings;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Sub;

public final class SubDatetimesEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Warnings warnings;
    private final EvalOperator.ExpressionEvaluator datetime;
    private final TemporalAmount temporalAmount;
    private final DriverContext driverContext;

    public SubDatetimesEvaluator(Source source, EvalOperator.ExpressionEvaluator datetime, TemporalAmount temporalAmount, DriverContext driverContext) {
        this.datetime = datetime;
        this.temporalAmount = temporalAmount;
        this.driverContext = driverContext;
        this.warnings = Warnings.createWarnings(driverContext.warningsMode(), source);
    }

    public Block eval(Page page) {
        try (LongBlock datetimeBlock = (LongBlock)this.datetime.eval(page);){
            LongVector datetimeVector = datetimeBlock.asVector();
            if (datetimeVector == null) {
                LongBlock longBlock = this.eval(page.getPositionCount(), datetimeBlock);
                return longBlock;
            }
            LongBlock longBlock = this.eval(page.getPositionCount(), datetimeVector);
            return longBlock;
        }
    }

    public LongBlock eval(int positionCount, LongBlock datetimeBlock) {
        try (LongBlock.Builder result = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (datetimeBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (datetimeBlock.getValueCount(p) != 1) {
                    if (datetimeBlock.getValueCount(p) > 1) {
                        this.warnings.registerException(new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                try {
                    result.appendLong(Sub.processDatetimes(datetimeBlock.getLong(datetimeBlock.getFirstValueIndex(p)), this.temporalAmount));
                    continue;
                }
                catch (ArithmeticException | DateTimeException e) {
                    this.warnings.registerException(e);
                    result.appendNull();
                }
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public LongBlock eval(int positionCount, LongVector datetimeVector) {
        try (LongBlock.Builder result = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                try {
                    result.appendLong(Sub.processDatetimes(datetimeVector.getLong(p), this.temporalAmount));
                    continue;
                }
                catch (ArithmeticException | DateTimeException e) {
                    this.warnings.registerException(e);
                    result.appendNull();
                }
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public String toString() {
        return "SubDatetimesEvaluator[datetime=" + this.datetime + ", temporalAmount=" + this.temporalAmount + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.datetime);
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory datetime;
        private final TemporalAmount temporalAmount;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory datetime, TemporalAmount temporalAmount) {
            this.source = source;
            this.datetime = datetime;
            this.temporalAmount = temporalAmount;
        }

        public SubDatetimesEvaluator get(DriverContext context) {
            return new SubDatetimesEvaluator(this.source, this.datetime.get(context), this.temporalAmount, context);
        }

        public String toString() {
            return "SubDatetimesEvaluator[datetime=" + this.datetime + ", temporalAmount=" + this.temporalAmount + "]";
        }
    }
}

