/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic;

import java.io.IOException;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.predicate.operator.arithmetic.BinaryComparisonInversible;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.util.NumericUtils;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Div;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.EsqlArithmeticOperation;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.MulDoublesEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.MulIntsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.MulLongsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.MulUnsignedLongsEvaluator;

public class Mul
extends EsqlArithmeticOperation
implements BinaryComparisonInversible {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Mul", Mul::new);

    public Mul(Source source, Expression left, Expression right) {
        super(source, left, right, EsqlArithmeticOperation.OperationSymbol.MUL, MulIntsEvaluator.Factory::new, MulLongsEvaluator.Factory::new, MulUnsignedLongsEvaluator.Factory::new, MulDoublesEvaluator.Factory::new);
    }

    private Mul(StreamInput in) throws IOException {
        super(in, EsqlArithmeticOperation.OperationSymbol.MUL, MulIntsEvaluator.Factory::new, MulLongsEvaluator.Factory::new, MulUnsignedLongsEvaluator.Factory::new, MulDoublesEvaluator.Factory::new);
    }

    public String getWriteableName() {
        return Mul.ENTRY.name;
    }

    public BinaryComparisonInversible.ArithmeticOperationFactory binaryComparisonInverse() {
        return Div::new;
    }

    protected boolean isCommutative() {
        return true;
    }

    public Mul swapLeftAndRight() {
        return new Mul(this.source(), this.right(), this.left());
    }

    protected NodeInfo<Mul> info() {
        return NodeInfo.create((Node)this, Mul::new, (Object)this.left(), (Object)this.right());
    }

    protected Mul replaceChildren(Expression left, Expression right) {
        return new Mul(this.source(), left, right);
    }

    static int processInts(int lhs, int rhs) {
        return Math.multiplyExact(lhs, rhs);
    }

    static long processLongs(long lhs, long rhs) {
        return Math.multiplyExact(lhs, rhs);
    }

    static long processUnsignedLongs(long lhs, long rhs) {
        return NumericUtils.unsignedLongMultiplyExact((long)lhs, (long)rhs);
    }

    static double processDoubles(double lhs, double rhs) {
        return lhs * rhs;
    }
}

