/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic;

import java.io.IOException;
import java.time.Duration;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAmount;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.predicate.operator.arithmetic.BinaryComparisonInversible;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DateUtils;
import org.elasticsearch.xpack.esql.core.util.NumericUtils;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.AddDatetimesEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.AddDoublesEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.AddIntsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.AddLongsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.AddUnsignedLongsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.DateTimeArithmeticOperation;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.EsqlArithmeticOperation;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Sub;

public class Add
extends DateTimeArithmeticOperation
implements BinaryComparisonInversible {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Add", Add::new);

    public Add(Source source, Expression left, Expression right) {
        super(source, left, right, EsqlArithmeticOperation.OperationSymbol.ADD, AddIntsEvaluator.Factory::new, AddLongsEvaluator.Factory::new, AddUnsignedLongsEvaluator.Factory::new, AddDoublesEvaluator.Factory::new, AddDatetimesEvaluator.Factory::new);
    }

    private Add(StreamInput in) throws IOException {
        super(in, EsqlArithmeticOperation.OperationSymbol.ADD, AddIntsEvaluator.Factory::new, AddLongsEvaluator.Factory::new, AddUnsignedLongsEvaluator.Factory::new, AddDoublesEvaluator.Factory::new, AddDatetimesEvaluator.Factory::new);
    }

    public String getWriteableName() {
        return Add.ENTRY.name;
    }

    protected NodeInfo<Add> info() {
        return NodeInfo.create((Node)this, Add::new, (Object)this.left(), (Object)this.right());
    }

    protected Add replaceChildren(Expression left, Expression right) {
        return new Add(this.source(), left, right);
    }

    public Add swapLeftAndRight() {
        return new Add(this.source(), this.right(), this.left());
    }

    public BinaryComparisonInversible.ArithmeticOperationFactory binaryComparisonInverse() {
        return Sub::new;
    }

    protected boolean isCommutative() {
        return true;
    }

    static int processInts(int lhs, int rhs) {
        return Math.addExact(lhs, rhs);
    }

    static long processLongs(long lhs, long rhs) {
        return Math.addExact(lhs, rhs);
    }

    public static long processUnsignedLongs(long lhs, long rhs) {
        return NumericUtils.unsignedLongAddExact((long)lhs, (long)rhs);
    }

    static double processDoubles(double lhs, double rhs) {
        return lhs + rhs;
    }

    static long processDatetimes(long datetime, TemporalAmount temporalAmount) {
        return DateUtils.asMillis((ZonedDateTime)DateUtils.asDateTime((long)datetime).plus(temporalAmount));
    }

    @Override
    public Period fold(Period left, Period right) {
        return left.plus(right);
    }

    @Override
    public Duration fold(Duration left, Duration right) {
        return left.plus(right);
    }
}

