/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.io.IOException;
import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.InvalidArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.expression.function.scalar.BinaryScalarFunction;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.EsqlTypeResolutions;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.SplitSingleByteEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.SplitVariableEvaluator;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public class Split
extends BinaryScalarFunction
implements EvaluatorMapper {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Split", Split::new);

    @FunctionInfo(returnType={"keyword"}, description="Split a single valued string into multiple strings.", examples={@Example(file="string", tag="split")})
    public Split(Source source, @Param(name="string", type={"keyword", "text"}, description="String expression. If `null`, the function returns `null`.") Expression str, @Param(name="delim", type={"keyword", "text"}, description="Delimiter. Only single byte delimiters are currently supported.") Expression delim) {
        super(source, str, delim);
    }

    private Split(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.str());
        out.writeNamedWriteable((NamedWriteable)this.delim());
    }

    public String getWriteableName() {
        return Split.ENTRY.name;
    }

    public DataType dataType() {
        return DataType.KEYWORD;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = EsqlTypeResolutions.isStringAndExact(this.left(), this.sourceText(), TypeResolutions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        return EsqlTypeResolutions.isStringAndExact(this.right(), this.sourceText(), TypeResolutions.ParamOrdinal.SECOND);
    }

    public boolean foldable() {
        return this.left().foldable() && this.right().foldable();
    }

    @Override
    public Object fold() {
        return EvaluatorMapper.super.fold();
    }

    static void process(BytesRefBlock.Builder builder, BytesRef str, byte delim, BytesRef scratch) {
        scratch.bytes = str.bytes;
        scratch.offset = str.offset;
        int end = str.offset + str.length;
        for (int i = str.offset; i < end; ++i) {
            if (str.bytes[i] != delim) continue;
            scratch.length = i - scratch.offset;
            if (scratch.offset == str.offset) {
                builder.beginPositionEntry();
            }
            builder.appendBytesRef(scratch);
            scratch.offset = i + 1;
        }
        if (scratch.offset == str.offset) {
            builder.appendBytesRef(str);
            return;
        }
        scratch.length = str.length - (scratch.offset - str.offset);
        builder.appendBytesRef(scratch);
        builder.endPositionEntry();
    }

    static void process(BytesRefBlock.Builder builder, BytesRef str, BytesRef delim, BytesRef scratch) {
        Split.checkDelimiter(delim);
        Split.process(builder, str, delim.bytes[delim.offset], scratch);
    }

    protected BinaryScalarFunction replaceChildren(Expression newLeft, Expression newRight) {
        return new Split(this.source(), newLeft, newRight);
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Split::new, (Object)this.left(), (Object)this.right());
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory str = toEvaluator.apply(this.left());
        if (!this.right().foldable()) {
            return new SplitVariableEvaluator.Factory(this.source(), str, toEvaluator.apply(this.right()), context -> new BytesRef());
        }
        BytesRef delim = (BytesRef)this.right().fold();
        Split.checkDelimiter(delim);
        return new SplitSingleByteEvaluator.Factory(this.source(), str, delim.bytes[delim.offset], context -> new BytesRef());
    }

    private static void checkDelimiter(BytesRef delim) {
        if (delim.length != 1) {
            throw new InvalidArgumentException("delimiter must be single byte for now", new Object[0]);
        }
    }

    Expression str() {
        return (Expression)this.children().get(0);
    }

    Expression delim() {
        return (Expression)this.children().get(1);
    }
}

