/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Warnings;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Right;

public final class RightEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Warnings warnings;
    private final BytesRef out;
    private final UnicodeUtil.UTF8CodePoint cp;
    private final EvalOperator.ExpressionEvaluator str;
    private final EvalOperator.ExpressionEvaluator length;
    private final DriverContext driverContext;

    public RightEvaluator(Source source, BytesRef out, UnicodeUtil.UTF8CodePoint cp, EvalOperator.ExpressionEvaluator str, EvalOperator.ExpressionEvaluator length, DriverContext driverContext) {
        this.out = out;
        this.cp = cp;
        this.str = str;
        this.length = length;
        this.driverContext = driverContext;
        this.warnings = Warnings.createWarnings(driverContext.warningsMode(), source);
    }

    public Block eval(Page page) {
        try (BytesRefBlock strBlock = (BytesRefBlock)this.str.eval(page);){
            BytesRefBlock bytesRefBlock;
            block20: {
                IntVector lengthVector;
                BytesRefVector strVector;
                IntBlock lengthBlock;
                block18: {
                    BytesRefBlock bytesRefBlock2;
                    block19: {
                        block16: {
                            BytesRefBlock bytesRefBlock3;
                            block17: {
                                lengthBlock = (IntBlock)this.length.eval(page);
                                try {
                                    strVector = strBlock.asVector();
                                    if (strVector != null) break block16;
                                    bytesRefBlock3 = this.eval(page.getPositionCount(), strBlock, lengthBlock);
                                    if (lengthBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (lengthBlock != null) {
                                        try {
                                            lengthBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                lengthBlock.close();
                            }
                            return bytesRefBlock3;
                        }
                        lengthVector = lengthBlock.asVector();
                        if (lengthVector != null) break block18;
                        bytesRefBlock2 = this.eval(page.getPositionCount(), strBlock, lengthBlock);
                        if (lengthBlock == null) break block19;
                        lengthBlock.close();
                    }
                    return bytesRefBlock2;
                }
                bytesRefBlock = this.eval(page.getPositionCount(), strVector, lengthVector).asBlock();
                if (lengthBlock == null) break block20;
                lengthBlock.close();
            }
            return bytesRefBlock;
        }
    }

    public BytesRefBlock eval(int positionCount, BytesRefBlock strBlock, IntBlock lengthBlock) {
        try (BytesRefBlock.Builder result = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            BytesRef strScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                if (strBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (strBlock.getValueCount(p) != 1) {
                    if (strBlock.getValueCount(p) > 1) {
                        this.warnings.registerException(new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                if (lengthBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (lengthBlock.getValueCount(p) != 1) {
                    if (lengthBlock.getValueCount(p) > 1) {
                        this.warnings.registerException(new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                result.appendBytesRef(Right.process(this.out, this.cp, strBlock.getBytesRef(strBlock.getFirstValueIndex(p), strScratch), lengthBlock.getInt(lengthBlock.getFirstValueIndex(p))));
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public BytesRefVector eval(int positionCount, BytesRefVector strVector, IntVector lengthVector) {
        try (BytesRefVector.Builder result = this.driverContext.blockFactory().newBytesRefVectorBuilder(positionCount);){
            BytesRef strScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                result.appendBytesRef(Right.process(this.out, this.cp, strVector.getBytesRef(p, strScratch), lengthVector.getInt(p)));
            }
            BytesRefVector bytesRefVector = result.build();
            return bytesRefVector;
        }
    }

    public String toString() {
        return "RightEvaluator[str=" + this.str + ", length=" + this.length + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.str, this.length});
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final Function<DriverContext, BytesRef> out;
        private final Function<DriverContext, UnicodeUtil.UTF8CodePoint> cp;
        private final EvalOperator.ExpressionEvaluator.Factory str;
        private final EvalOperator.ExpressionEvaluator.Factory length;

        public Factory(Source source, Function<DriverContext, BytesRef> out, Function<DriverContext, UnicodeUtil.UTF8CodePoint> cp, EvalOperator.ExpressionEvaluator.Factory str, EvalOperator.ExpressionEvaluator.Factory length) {
            this.source = source;
            this.out = out;
            this.cp = cp;
            this.str = str;
            this.length = length;
        }

        public RightEvaluator get(DriverContext context) {
            return new RightEvaluator(this.source, this.out.apply(context), this.cp.apply(context), this.str.get(context), this.length.get(context), context);
        }

        public String toString() {
            return "RightEvaluator[str=" + this.str + ", length=" + this.length + "]";
        }
    }
}

