/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Warnings;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Replace;

public final class ReplaceConstantEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Warnings warnings;
    private final EvalOperator.ExpressionEvaluator str;
    private final Pattern regex;
    private final EvalOperator.ExpressionEvaluator newStr;
    private final DriverContext driverContext;

    public ReplaceConstantEvaluator(Source source, EvalOperator.ExpressionEvaluator str, Pattern regex, EvalOperator.ExpressionEvaluator newStr, DriverContext driverContext) {
        this.str = str;
        this.regex = regex;
        this.newStr = newStr;
        this.driverContext = driverContext;
        this.warnings = Warnings.createWarnings(driverContext.warningsMode(), source);
    }

    public Block eval(Page page) {
        try (BytesRefBlock strBlock = (BytesRefBlock)this.str.eval(page);){
            BytesRefBlock bytesRefBlock;
            block20: {
                BytesRefVector newStrVector;
                BytesRefVector strVector;
                BytesRefBlock newStrBlock;
                block18: {
                    BytesRefBlock bytesRefBlock2;
                    block19: {
                        block16: {
                            BytesRefBlock bytesRefBlock3;
                            block17: {
                                newStrBlock = (BytesRefBlock)this.newStr.eval(page);
                                try {
                                    strVector = strBlock.asVector();
                                    if (strVector != null) break block16;
                                    bytesRefBlock3 = this.eval(page.getPositionCount(), strBlock, newStrBlock);
                                    if (newStrBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (newStrBlock != null) {
                                        try {
                                            newStrBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                newStrBlock.close();
                            }
                            return bytesRefBlock3;
                        }
                        newStrVector = newStrBlock.asVector();
                        if (newStrVector != null) break block18;
                        bytesRefBlock2 = this.eval(page.getPositionCount(), strBlock, newStrBlock);
                        if (newStrBlock == null) break block19;
                        newStrBlock.close();
                    }
                    return bytesRefBlock2;
                }
                bytesRefBlock = this.eval(page.getPositionCount(), strVector, newStrVector);
                if (newStrBlock == null) break block20;
                newStrBlock.close();
            }
            return bytesRefBlock;
        }
    }

    public BytesRefBlock eval(int positionCount, BytesRefBlock strBlock, BytesRefBlock newStrBlock) {
        try (BytesRefBlock.Builder result = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            BytesRef strScratch = new BytesRef();
            BytesRef newStrScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                if (strBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (strBlock.getValueCount(p) != 1) {
                    if (strBlock.getValueCount(p) > 1) {
                        this.warnings.registerException(new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                if (newStrBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (newStrBlock.getValueCount(p) != 1) {
                    if (newStrBlock.getValueCount(p) > 1) {
                        this.warnings.registerException(new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                try {
                    result.appendBytesRef(Replace.process(strBlock.getBytesRef(strBlock.getFirstValueIndex(p), strScratch), this.regex, newStrBlock.getBytesRef(newStrBlock.getFirstValueIndex(p), newStrScratch)));
                    continue;
                }
                catch (PatternSyntaxException e) {
                    this.warnings.registerException(e);
                    result.appendNull();
                }
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public BytesRefBlock eval(int positionCount, BytesRefVector strVector, BytesRefVector newStrVector) {
        try (BytesRefBlock.Builder result = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            BytesRef strScratch = new BytesRef();
            BytesRef newStrScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                try {
                    result.appendBytesRef(Replace.process(strVector.getBytesRef(p, strScratch), this.regex, newStrVector.getBytesRef(p, newStrScratch)));
                    continue;
                }
                catch (PatternSyntaxException e) {
                    this.warnings.registerException(e);
                    result.appendNull();
                }
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public String toString() {
        return "ReplaceConstantEvaluator[str=" + this.str + ", regex=" + this.regex + ", newStr=" + this.newStr + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.str, this.newStr});
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory str;
        private final Pattern regex;
        private final EvalOperator.ExpressionEvaluator.Factory newStr;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory str, Pattern regex, EvalOperator.ExpressionEvaluator.Factory newStr) {
            this.source = source;
            this.str = str;
            this.regex = regex;
            this.newStr = newStr;
        }

        public ReplaceConstantEvaluator get(DriverContext context) {
            return new ReplaceConstantEvaluator(this.source, this.str.get(context), this.regex, this.newStr.get(context), context);
        }

        public String toString() {
            return "ReplaceConstantEvaluator[str=" + this.str + ", regex=" + this.regex + ", newStr=" + this.newStr + "]";
        }
    }
}

