/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Warnings;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Locate;

public final class LocateNoStartEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Warnings warnings;
    private final EvalOperator.ExpressionEvaluator str;
    private final EvalOperator.ExpressionEvaluator substr;
    private final DriverContext driverContext;

    public LocateNoStartEvaluator(Source source, EvalOperator.ExpressionEvaluator str, EvalOperator.ExpressionEvaluator substr, DriverContext driverContext) {
        this.str = str;
        this.substr = substr;
        this.driverContext = driverContext;
        this.warnings = Warnings.createWarnings(driverContext.warningsMode(), source);
    }

    public Block eval(Page page) {
        try (BytesRefBlock strBlock = (BytesRefBlock)this.str.eval(page);){
            IntBlock intBlock;
            block20: {
                BytesRefVector substrVector;
                BytesRefVector strVector;
                BytesRefBlock substrBlock;
                block18: {
                    IntBlock intBlock2;
                    block19: {
                        block16: {
                            IntBlock intBlock3;
                            block17: {
                                substrBlock = (BytesRefBlock)this.substr.eval(page);
                                try {
                                    strVector = strBlock.asVector();
                                    if (strVector != null) break block16;
                                    intBlock3 = this.eval(page.getPositionCount(), strBlock, substrBlock);
                                    if (substrBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (substrBlock != null) {
                                        try {
                                            substrBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                substrBlock.close();
                            }
                            return intBlock3;
                        }
                        substrVector = substrBlock.asVector();
                        if (substrVector != null) break block18;
                        intBlock2 = this.eval(page.getPositionCount(), strBlock, substrBlock);
                        if (substrBlock == null) break block19;
                        substrBlock.close();
                    }
                    return intBlock2;
                }
                intBlock = this.eval(page.getPositionCount(), strVector, substrVector).asBlock();
                if (substrBlock == null) break block20;
                substrBlock.close();
            }
            return intBlock;
        }
    }

    public IntBlock eval(int positionCount, BytesRefBlock strBlock, BytesRefBlock substrBlock) {
        try (IntBlock.Builder result = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            BytesRef strScratch = new BytesRef();
            BytesRef substrScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                if (strBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (strBlock.getValueCount(p) != 1) {
                    if (strBlock.getValueCount(p) > 1) {
                        this.warnings.registerException(new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                if (substrBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (substrBlock.getValueCount(p) != 1) {
                    if (substrBlock.getValueCount(p) > 1) {
                        this.warnings.registerException(new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                result.appendInt(Locate.process(strBlock.getBytesRef(strBlock.getFirstValueIndex(p), strScratch), substrBlock.getBytesRef(substrBlock.getFirstValueIndex(p), substrScratch)));
            }
            IntBlock intBlock = result.build();
            return intBlock;
        }
    }

    public IntVector eval(int positionCount, BytesRefVector strVector, BytesRefVector substrVector) {
        try (IntVector.FixedBuilder result = this.driverContext.blockFactory().newIntVectorFixedBuilder(positionCount);){
            BytesRef strScratch = new BytesRef();
            BytesRef substrScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                result.appendInt(p, Locate.process(strVector.getBytesRef(p, strScratch), substrVector.getBytesRef(p, substrScratch)));
            }
            IntVector intVector = result.build();
            return intVector;
        }
    }

    public String toString() {
        return "LocateNoStartEvaluator[str=" + this.str + ", substr=" + this.substr + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.str, this.substr});
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory str;
        private final EvalOperator.ExpressionEvaluator.Factory substr;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory str, EvalOperator.ExpressionEvaluator.Factory substr) {
            this.source = source;
            this.str = str;
            this.substr = substr;
        }

        public LocateNoStartEvaluator get(DriverContext context) {
            return new LocateNoStartEvaluator(this.source, this.str.get(context), this.substr.get(context), context);
        }

        public String toString() {
            return "LocateNoStartEvaluator[str=" + this.str + ", substr=" + this.substr + "]";
        }
    }
}

