/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Warnings;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Length;

public final class LengthEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Warnings warnings;
    private final EvalOperator.ExpressionEvaluator val;
    private final DriverContext driverContext;

    public LengthEvaluator(Source source, EvalOperator.ExpressionEvaluator val, DriverContext driverContext) {
        this.val = val;
        this.driverContext = driverContext;
        this.warnings = Warnings.createWarnings(driverContext.warningsMode(), source);
    }

    public Block eval(Page page) {
        try (BytesRefBlock valBlock = (BytesRefBlock)this.val.eval(page);){
            BytesRefVector valVector = valBlock.asVector();
            if (valVector == null) {
                IntBlock intBlock = this.eval(page.getPositionCount(), valBlock);
                return intBlock;
            }
            IntBlock intBlock = this.eval(page.getPositionCount(), valVector).asBlock();
            return intBlock;
        }
    }

    public IntBlock eval(int positionCount, BytesRefBlock valBlock) {
        try (IntBlock.Builder result = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            BytesRef valScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                if (valBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (valBlock.getValueCount(p) != 1) {
                    if (valBlock.getValueCount(p) > 1) {
                        this.warnings.registerException(new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                result.appendInt(Length.process(valBlock.getBytesRef(valBlock.getFirstValueIndex(p), valScratch)));
            }
            IntBlock intBlock = result.build();
            return intBlock;
        }
    }

    public IntVector eval(int positionCount, BytesRefVector valVector) {
        try (IntVector.FixedBuilder result = this.driverContext.blockFactory().newIntVectorFixedBuilder(positionCount);){
            BytesRef valScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                result.appendInt(p, Length.process(valVector.getBytesRef(p, valScratch)));
            }
            IntVector intVector = result.build();
            return intVector;
        }
    }

    public String toString() {
        return "LengthEvaluator[val=" + this.val + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.val);
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory val;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory val) {
            this.source = source;
            this.val = val;
        }

        public LengthEvaluator get(DriverContext context) {
            return new LengthEvaluator(this.source, this.val.get(context), context);
        }

        public String toString() {
            return "LengthEvaluator[val=" + this.val + "]";
        }
    }
}

