/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.LTrimEvaluator;

public class LTrim
extends UnaryScalarFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "LTrim", LTrim::new);

    @FunctionInfo(returnType={"keyword", "text"}, description="Removes leading whitespaces from a string.", examples={@Example(file="string", tag="ltrim")})
    public LTrim(Source source, @Param(name="string", type={"keyword", "text"}, description="String expression. If `null`, the function returns `null`.") Expression str) {
        super(source, str);
    }

    private LTrim(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return LTrim.ENTRY.name;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isString((Expression)this.field, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        return new LTrimEvaluator.Factory(this.source(), toEvaluator.apply(this.field()));
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new LTrim(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, LTrim::new, (Object)this.field());
    }

    static BytesRef process(BytesRef val) {
        int offset;
        UnicodeUtil.UTF8CodePoint codePoint = new UnicodeUtil.UTF8CodePoint();
        for (offset = val.offset; offset < val.offset + val.length; offset += codePoint.numBytes) {
            codePoint = UnicodeUtil.codePointAt((byte[])val.bytes, (int)offset, (UnicodeUtil.UTF8CodePoint)codePoint);
            if (!Character.isWhitespace(codePoint.codePoint)) break;
        }
        return new BytesRef(val.bytes, offset, val.length + val.offset - offset);
    }
}

