/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.util.Arrays;
import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.BreakingBytesRefBuilder;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Warnings;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Concat;

public final class ConcatEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Warnings warnings;
    private final BreakingBytesRefBuilder scratch;
    private final EvalOperator.ExpressionEvaluator[] values;
    private final DriverContext driverContext;

    public ConcatEvaluator(Source source, BreakingBytesRefBuilder scratch, EvalOperator.ExpressionEvaluator[] values, DriverContext driverContext) {
        this.scratch = scratch;
        this.values = values;
        this.driverContext = driverContext;
        this.warnings = Warnings.createWarnings(driverContext.warningsMode(), source);
    }

    public Block eval(Page page) {
        BytesRefBlock[] valuesBlocks = new BytesRefBlock[this.values.length];
        try (Releasable valuesRelease = Releasables.wrap((Releasable[])valuesBlocks);){
            for (int i = 0; i < valuesBlocks.length; ++i) {
                valuesBlocks[i] = (BytesRefBlock)this.values[i].eval(page);
            }
            BytesRefVector[] valuesVectors = new BytesRefVector[this.values.length];
            for (int i = 0; i < valuesBlocks.length; ++i) {
                valuesVectors[i] = valuesBlocks[i].asVector();
                if (valuesVectors[i] != null) continue;
                BytesRefBlock bytesRefBlock = this.eval(page.getPositionCount(), valuesBlocks);
                return bytesRefBlock;
            }
            BytesRefBlock bytesRefBlock = this.eval(page.getPositionCount(), valuesVectors).asBlock();
            return bytesRefBlock;
        }
    }

    public BytesRefBlock eval(int positionCount, BytesRefBlock[] valuesBlocks) {
        try (BytesRefBlock.Builder result = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            BytesRef[] valuesValues = new BytesRef[this.values.length];
            BytesRef[] valuesScratch = new BytesRef[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                valuesScratch[i] = new BytesRef();
            }
            block6: for (int p = 0; p < positionCount; ++p) {
                int i;
                for (i = 0; i < valuesBlocks.length; ++i) {
                    if (valuesBlocks[i].isNull(p)) {
                        result.appendNull();
                        continue block6;
                    }
                    if (valuesBlocks[i].getValueCount(p) == 1) continue;
                    if (valuesBlocks[i].getValueCount(p) > 1) {
                        this.warnings.registerException(new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue block6;
                }
                for (i = 0; i < valuesBlocks.length; ++i) {
                    int o = valuesBlocks[i].getFirstValueIndex(p);
                    valuesValues[i] = valuesBlocks[i].getBytesRef(o, valuesScratch[i]);
                }
                result.appendBytesRef(Concat.process(this.scratch, valuesValues));
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public BytesRefVector eval(int positionCount, BytesRefVector[] valuesVectors) {
        try (BytesRefVector.Builder result = this.driverContext.blockFactory().newBytesRefVectorBuilder(positionCount);){
            BytesRef[] valuesValues = new BytesRef[this.values.length];
            BytesRef[] valuesScratch = new BytesRef[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                valuesScratch[i] = new BytesRef();
            }
            for (int p = 0; p < positionCount; ++p) {
                for (int i = 0; i < valuesVectors.length; ++i) {
                    valuesValues[i] = valuesVectors[i].getBytesRef(p, valuesScratch[i]);
                }
                result.appendBytesRef(Concat.process(this.scratch, valuesValues));
            }
            BytesRefVector bytesRefVector = result.build();
            return bytesRefVector;
        }
    }

    public String toString() {
        return "ConcatEvaluator[values=" + Arrays.toString(this.values) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.scratch, () -> Releasables.close((Releasable[])this.values)});
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final Function<DriverContext, BreakingBytesRefBuilder> scratch;
        private final EvalOperator.ExpressionEvaluator.Factory[] values;

        public Factory(Source source, Function<DriverContext, BreakingBytesRefBuilder> scratch, EvalOperator.ExpressionEvaluator.Factory[] values) {
            this.source = source;
            this.scratch = scratch;
            this.values = values;
        }

        public ConcatEvaluator get(DriverContext context) {
            EvalOperator.ExpressionEvaluator[] values = (EvalOperator.ExpressionEvaluator[])Arrays.stream(this.values).map(a -> a.get(context)).toArray(EvalOperator.ExpressionEvaluator[]::new);
            return new ConcatEvaluator(this.source, this.scratch.apply(context), values, context);
        }

        public String toString() {
            return "ConcatEvaluator[values=" + Arrays.toString(this.values) + "]";
        }
    }
}

