/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Warnings;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StDistance;

public final class StDistanceGeoPointDocValuesAndSourceEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Warnings warnings;
    private final EvalOperator.ExpressionEvaluator leftValue;
    private final EvalOperator.ExpressionEvaluator rightValue;
    private final DriverContext driverContext;

    public StDistanceGeoPointDocValuesAndSourceEvaluator(Source source, EvalOperator.ExpressionEvaluator leftValue, EvalOperator.ExpressionEvaluator rightValue, DriverContext driverContext) {
        this.leftValue = leftValue;
        this.rightValue = rightValue;
        this.driverContext = driverContext;
        this.warnings = Warnings.createWarnings(driverContext.warningsMode(), source);
    }

    public Block eval(Page page) {
        try (LongBlock leftValueBlock = (LongBlock)this.leftValue.eval(page);){
            DoubleBlock doubleBlock;
            block20: {
                BytesRefVector rightValueVector;
                LongVector leftValueVector;
                BytesRefBlock rightValueBlock;
                block18: {
                    DoubleBlock doubleBlock2;
                    block19: {
                        block16: {
                            DoubleBlock doubleBlock3;
                            block17: {
                                rightValueBlock = (BytesRefBlock)this.rightValue.eval(page);
                                try {
                                    leftValueVector = leftValueBlock.asVector();
                                    if (leftValueVector != null) break block16;
                                    doubleBlock3 = this.eval(page.getPositionCount(), leftValueBlock, rightValueBlock);
                                    if (rightValueBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (rightValueBlock != null) {
                                        try {
                                            rightValueBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                rightValueBlock.close();
                            }
                            return doubleBlock3;
                        }
                        rightValueVector = rightValueBlock.asVector();
                        if (rightValueVector != null) break block18;
                        doubleBlock2 = this.eval(page.getPositionCount(), leftValueBlock, rightValueBlock);
                        if (rightValueBlock == null) break block19;
                        rightValueBlock.close();
                    }
                    return doubleBlock2;
                }
                doubleBlock = this.eval(page.getPositionCount(), leftValueVector, rightValueVector);
                if (rightValueBlock == null) break block20;
                rightValueBlock.close();
            }
            return doubleBlock;
        }
    }

    public DoubleBlock eval(int positionCount, LongBlock leftValueBlock, BytesRefBlock rightValueBlock) {
        try (DoubleBlock.Builder result = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            BytesRef rightValueScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                if (leftValueBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (leftValueBlock.getValueCount(p) != 1) {
                    if (leftValueBlock.getValueCount(p) > 1) {
                        this.warnings.registerException(new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                if (rightValueBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (rightValueBlock.getValueCount(p) != 1) {
                    if (rightValueBlock.getValueCount(p) > 1) {
                        this.warnings.registerException(new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                try {
                    result.appendDouble(StDistance.processGeoPointDocValuesAndSource(leftValueBlock.getLong(leftValueBlock.getFirstValueIndex(p)), rightValueBlock.getBytesRef(rightValueBlock.getFirstValueIndex(p), rightValueScratch)));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.warnings.registerException(e);
                    result.appendNull();
                }
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public DoubleBlock eval(int positionCount, LongVector leftValueVector, BytesRefVector rightValueVector) {
        try (DoubleBlock.Builder result = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            BytesRef rightValueScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                try {
                    result.appendDouble(StDistance.processGeoPointDocValuesAndSource(leftValueVector.getLong(p), rightValueVector.getBytesRef(p, rightValueScratch)));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.warnings.registerException(e);
                    result.appendNull();
                }
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public String toString() {
        return "StDistanceGeoPointDocValuesAndSourceEvaluator[leftValue=" + this.leftValue + ", rightValue=" + this.rightValue + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.leftValue, this.rightValue});
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory leftValue;
        private final EvalOperator.ExpressionEvaluator.Factory rightValue;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory leftValue, EvalOperator.ExpressionEvaluator.Factory rightValue) {
            this.source = source;
            this.leftValue = leftValue;
            this.rightValue = rightValue;
        }

        public StDistanceGeoPointDocValuesAndSourceEvaluator get(DriverContext context) {
            return new StDistanceGeoPointDocValuesAndSourceEvaluator(this.source, this.leftValue.get(context), this.rightValue.get(context), context);
        }

        public String toString() {
            return "StDistanceGeoPointDocValuesAndSourceEvaluator[leftValue=" + this.leftValue + ", rightValue=" + this.rightValue + "]";
        }
    }
}

