/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Warnings;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StDistance;

public final class StDistanceCartesianPointDocValuesAndConstantEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Warnings warnings;
    private final EvalOperator.ExpressionEvaluator leftValue;
    private final Point rightValue;
    private final DriverContext driverContext;

    public StDistanceCartesianPointDocValuesAndConstantEvaluator(Source source, EvalOperator.ExpressionEvaluator leftValue, Point rightValue, DriverContext driverContext) {
        this.leftValue = leftValue;
        this.rightValue = rightValue;
        this.driverContext = driverContext;
        this.warnings = Warnings.createWarnings(driverContext.warningsMode(), source);
    }

    public Block eval(Page page) {
        try (LongBlock leftValueBlock = (LongBlock)this.leftValue.eval(page);){
            LongVector leftValueVector = leftValueBlock.asVector();
            if (leftValueVector == null) {
                DoubleBlock doubleBlock = this.eval(page.getPositionCount(), leftValueBlock);
                return doubleBlock;
            }
            DoubleBlock doubleBlock = this.eval(page.getPositionCount(), leftValueVector);
            return doubleBlock;
        }
    }

    public DoubleBlock eval(int positionCount, LongBlock leftValueBlock) {
        try (DoubleBlock.Builder result = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (leftValueBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (leftValueBlock.getValueCount(p) != 1) {
                    if (leftValueBlock.getValueCount(p) > 1) {
                        this.warnings.registerException(new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                try {
                    result.appendDouble(StDistance.processCartesianPointDocValuesAndConstant(leftValueBlock.getLong(leftValueBlock.getFirstValueIndex(p)), this.rightValue));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.warnings.registerException(e);
                    result.appendNull();
                }
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public DoubleBlock eval(int positionCount, LongVector leftValueVector) {
        try (DoubleBlock.Builder result = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                try {
                    result.appendDouble(StDistance.processCartesianPointDocValuesAndConstant(leftValueVector.getLong(p), this.rightValue));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.warnings.registerException(e);
                    result.appendNull();
                }
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public String toString() {
        return "StDistanceCartesianPointDocValuesAndConstantEvaluator[leftValue=" + this.leftValue + ", rightValue=" + this.rightValue + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.leftValue);
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory leftValue;
        private final Point rightValue;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory leftValue, Point rightValue) {
            this.source = source;
            this.leftValue = leftValue;
            this.rightValue = rightValue;
        }

        public StDistanceCartesianPointDocValuesAndConstantEvaluator get(DriverContext context) {
            return new StDistanceCartesianPointDocValuesAndConstantEvaluator(this.source, this.leftValue.get(context), this.rightValue, context);
        }

        public String toString() {
            return "StDistanceCartesianPointDocValuesAndConstantEvaluator[leftValue=" + this.leftValue + ", rightValue=" + this.rightValue + "]";
        }
    }
}

