/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import java.io.IOException;
import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.SloppyMath;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.lucene.spatial.CoordinateEncoder;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.SpatialCoordinateTypes;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.BinarySpatialFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialRelatesUtils;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StDistanceCartesianPointDocValuesAndConstantEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StDistanceCartesianPointDocValuesAndSourceEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StDistanceCartesianSourceAndConstantEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StDistanceCartesianSourceAndSourceEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StDistanceGeoPointDocValuesAndConstantEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StDistanceGeoPointDocValuesAndSourceEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StDistanceGeoSourceAndConstantEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StDistanceGeoSourceAndSourceEvaluator;

public class StDistance
extends BinarySpatialFunction
implements EvaluatorMapper {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "StDistance", StDistance::new);
    public static final DistanceCalculator GEO = new GeoDistanceCalculator();
    public static final DistanceCalculator CARTESIAN = new CartesianDistanceCalculator();

    @FunctionInfo(returnType={"double"}, description="Computes the distance between two points.\nFor cartesian geometries, this is the pythagorean distance in the same units as the original coordinates.\nFor geographic geometries, this is the circular distance along the great circle in meters.", examples={@Example(file="spatial", tag="st_distance-airports")})
    public StDistance(Source source, @Param(name="geomA", type={"geo_point", "cartesian_point"}, description="Expression of type `geo_point` or `cartesian_point`.\nIf `null`, the function returns `null`.") Expression left, @Param(name="geomB", type={"geo_point", "cartesian_point"}, description="Expression of type `geo_point` or `cartesian_point`.\nIf `null`, the function returns `null`.\nThe second parameter must also have the same coordinate system as the first.\nThis means it is not possible to combine `geo_point` and `cartesian_point` parameters.") Expression right) {
        super(source, left, right, false, false, true);
    }

    protected StDistance(Source source, Expression left, Expression right, boolean leftDocValues, boolean rightDocValues) {
        super(source, left, right, leftDocValues, rightDocValues, true);
    }

    private StDistance(StreamInput in) throws IOException {
        super(in, false, false, true);
    }

    public String getWriteableName() {
        return StDistance.ENTRY.name;
    }

    public DataType dataType() {
        return DataType.DOUBLE;
    }

    protected StDistance replaceChildren(Expression newLeft, Expression newRight) {
        return new StDistance(this.source(), newLeft, newRight, this.leftDocValues, this.rightDocValues);
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, StDistance::new, (Object)this.left(), (Object)this.right());
    }

    @Override
    public Object fold() {
        Geometry leftGeom = SpatialRelatesUtils.makeGeometryFromLiteral(this.left());
        Geometry rightGeom = SpatialRelatesUtils.makeGeometryFromLiteral(this.right());
        return this.crsType == BinarySpatialFunction.SpatialCrsType.GEO ? GEO.distance(leftGeom, rightGeom) : CARTESIAN.distance(leftGeom, rightGeom);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        if (this.right().foldable()) {
            return this.toEvaluator(toEvaluator, this.left(), SpatialRelatesUtils.makeGeometryFromLiteral(this.right()), this.leftDocValues);
        }
        if (this.left().foldable()) {
            return this.toEvaluator(toEvaluator, this.right(), SpatialRelatesUtils.makeGeometryFromLiteral(this.left()), this.rightDocValues);
        }
        EvalOperator.ExpressionEvaluator.Factory leftE = toEvaluator.apply(this.left());
        EvalOperator.ExpressionEvaluator.Factory rightE = toEvaluator.apply(this.right());
        if (this.crsType() == BinarySpatialFunction.SpatialCrsType.GEO) {
            if (this.leftDocValues) {
                return new StDistanceGeoPointDocValuesAndSourceEvaluator.Factory(this.source(), leftE, rightE);
            }
            if (this.rightDocValues) {
                return new StDistanceGeoPointDocValuesAndSourceEvaluator.Factory(this.source(), rightE, leftE);
            }
            return new StDistanceGeoSourceAndSourceEvaluator.Factory(this.source(), leftE, rightE);
        }
        if (this.crsType() == BinarySpatialFunction.SpatialCrsType.CARTESIAN) {
            if (this.leftDocValues) {
                return new StDistanceCartesianPointDocValuesAndSourceEvaluator.Factory(this.source(), leftE, rightE);
            }
            if (this.rightDocValues) {
                return new StDistanceCartesianPointDocValuesAndSourceEvaluator.Factory(this.source(), rightE, leftE);
            }
            return new StDistanceCartesianSourceAndSourceEvaluator.Factory(this.source(), leftE, rightE);
        }
        throw EsqlIllegalArgumentException.illegalDataType(this.crsType().name());
    }

    private EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator, Expression field, Geometry geometry, boolean docValues) {
        if (geometry instanceof Point) {
            Point point = (Point)geometry;
            return this.toEvaluator(toEvaluator, field, point, docValues);
        }
        throw new IllegalArgumentException("Unsupported geometry type for ST_DISTANCE: " + geometry.type().name());
    }

    private EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator, Expression field, Point point, boolean docValues) {
        EvalOperator.ExpressionEvaluator.Factory fieldEvaluator = toEvaluator.apply(field);
        if (this.crsType() == BinarySpatialFunction.SpatialCrsType.GEO) {
            if (docValues) {
                return new StDistanceGeoPointDocValuesAndConstantEvaluator.Factory(this.source(), fieldEvaluator, point);
            }
            return new StDistanceGeoSourceAndConstantEvaluator.Factory(this.source(), fieldEvaluator, point);
        }
        if (this.crsType() == BinarySpatialFunction.SpatialCrsType.CARTESIAN) {
            if (docValues) {
                return new StDistanceCartesianPointDocValuesAndConstantEvaluator.Factory(this.source(), fieldEvaluator, point);
            }
            return new StDistanceCartesianSourceAndConstantEvaluator.Factory(this.source(), fieldEvaluator, point);
        }
        throw EsqlIllegalArgumentException.illegalDataType(this.crsType().name());
    }

    static double processGeoSourceAndConstant(BytesRef leftValue, Point rightValue) throws IOException {
        return GEO.distance(leftValue, rightValue);
    }

    static double processGeoSourceAndSource(BytesRef leftValue, BytesRef rightValue) throws IOException {
        return GEO.distance(leftValue, rightValue);
    }

    static double processGeoPointDocValuesAndConstant(long leftValue, Point rightValue) {
        return GEO.distance(leftValue, (Geometry)rightValue);
    }

    static double processGeoPointDocValuesAndSource(long leftValue, BytesRef rightValue) {
        Geometry geometry = SpatialCoordinateTypes.UNSPECIFIED.wkbToGeometry(rightValue);
        return GEO.distance(leftValue, geometry);
    }

    static double processCartesianSourceAndConstant(BytesRef leftValue, Point rightValue) throws IOException {
        return CARTESIAN.distance(leftValue, rightValue);
    }

    static double processCartesianSourceAndSource(BytesRef leftValue, BytesRef rightValue) throws IOException {
        return CARTESIAN.distance(leftValue, rightValue);
    }

    static double processCartesianPointDocValuesAndConstant(long leftValue, Point rightValue) {
        return CARTESIAN.distance(leftValue, (Geometry)rightValue);
    }

    static double processCartesianPointDocValuesAndSource(long leftValue, BytesRef rightValue) {
        Geometry geometry = SpatialCoordinateTypes.UNSPECIFIED.wkbToGeometry(rightValue);
        return CARTESIAN.distance(leftValue, geometry);
    }

    public static abstract class DistanceCalculator
    extends BinarySpatialFunction.BinarySpatialComparator<Double> {
        protected DistanceCalculator(SpatialCoordinateTypes spatialCoordinateType, CoordinateEncoder encoder) {
            super(spatialCoordinateType, encoder);
        }

        @Override
        protected Double compare(BytesRef left, BytesRef right) throws IOException {
            return this.distance(left, right);
        }

        protected abstract double distance(Point var1, Point var2);

        protected double distance(long encoded, Geometry right) {
            Point point = this.spatialCoordinateType.longAsPoint(encoded);
            return this.distance(point, (Point)right);
        }

        protected double distance(Geometry left, Geometry right) {
            return this.distance((Point)left, (Point)right);
        }

        public double distance(BytesRef left, BytesRef right) {
            return this.distance(this.fromBytesRef(left), this.fromBytesRef(right));
        }

        public double distance(BytesRef left, Point right) {
            return this.distance(this.fromBytesRef(left), (Geometry)right);
        }
    }

    protected static class GeoDistanceCalculator
    extends DistanceCalculator {
        protected GeoDistanceCalculator() {
            super(SpatialCoordinateTypes.GEO, CoordinateEncoder.GEO);
        }

        @Override
        protected double distance(Point left, Point right) {
            return SloppyMath.haversinMeters((double)GeoUtils.quantizeLat((double)left.getY()), (double)GeoUtils.quantizeLon((double)left.getX()), (double)GeoUtils.quantizeLat((double)right.getY()), (double)GeoUtils.quantizeLon((double)right.getX()));
        }
    }

    protected static class CartesianDistanceCalculator
    extends DistanceCalculator {
        protected CartesianDistanceCalculator() {
            super(SpatialCoordinateTypes.CARTESIAN, CoordinateEncoder.CARTESIAN);
        }

        @Override
        protected double distance(Point left, Point right) {
            double diffX = left.getX() - right.getX();
            double diffY = left.getY() - right.getY();
            return Math.sqrt(diffX * diffX + diffY * diffY);
        }
    }
}

