/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.geo.LatLonGeometry;
import org.apache.lucene.geo.XYGeometry;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.geo.LuceneGeometriesUtils;
import org.elasticsearch.common.geo.Orientation;
import org.elasticsearch.geometry.Circle;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.ShapeType;
import org.elasticsearch.index.mapper.GeoShapeIndexer;
import org.elasticsearch.index.mapper.ShapeIndexer;
import org.elasticsearch.lucene.spatial.CartesianShapeIndexer;
import org.elasticsearch.lucene.spatial.CentroidCalculator;
import org.elasticsearch.lucene.spatial.CoordinateEncoder;
import org.elasticsearch.lucene.spatial.GeometryDocValueReader;
import org.elasticsearch.lucene.spatial.GeometryDocValueWriter;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.planner.ExpressionTranslators;
import org.elasticsearch.xpack.esql.core.util.SpatialCoordinateTypes;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.BinarySpatialFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.LuceneComponent2DUtils;

public class SpatialRelatesUtils {
    static Component2D asLuceneComponent2D(BinarySpatialFunction.SpatialCrsType crsType, Expression expression) {
        return SpatialRelatesUtils.asLuceneComponent2D(crsType, SpatialRelatesUtils.makeGeometryFromLiteral(expression));
    }

    static Component2D asLuceneComponent2D(BinarySpatialFunction.SpatialCrsType crsType, Geometry geometry) {
        if (crsType == BinarySpatialFunction.SpatialCrsType.GEO) {
            LatLonGeometry[] luceneGeometries = LuceneGeometriesUtils.toLatLonGeometry((Geometry)geometry, (boolean)true, t -> {});
            return LatLonGeometry.create((LatLonGeometry[])luceneGeometries);
        }
        XYGeometry[] luceneGeometries = LuceneGeometriesUtils.toXYGeometry((Geometry)geometry, t -> {});
        return XYGeometry.create((XYGeometry[])luceneGeometries);
    }

    static Component2D[] asLuceneComponent2Ds(BinarySpatialFunction.SpatialCrsType crsType, Expression expression) {
        return SpatialRelatesUtils.asLuceneComponent2Ds(crsType, SpatialRelatesUtils.makeGeometryFromLiteral(expression));
    }

    static Component2D[] asLuceneComponent2Ds(BinarySpatialFunction.SpatialCrsType crsType, Geometry geometry) {
        if (crsType == BinarySpatialFunction.SpatialCrsType.GEO) {
            LatLonGeometry[] luceneGeometries = LuceneGeometriesUtils.toLatLonGeometry((Geometry)geometry, (boolean)true, t -> {});
            return LuceneComponent2DUtils.createLatLonComponents(luceneGeometries);
        }
        XYGeometry[] luceneGeometries = LuceneGeometriesUtils.toXYGeometry((Geometry)geometry, t -> {});
        return LuceneComponent2DUtils.createXYComponents(luceneGeometries);
    }

    static GeometryDocValueReader asGeometryDocValueReader(BinarySpatialFunction.SpatialCrsType crsType, Expression expression) throws IOException {
        Geometry geometry = SpatialRelatesUtils.makeGeometryFromLiteral(expression);
        if (crsType == BinarySpatialFunction.SpatialCrsType.GEO) {
            return SpatialRelatesUtils.asGeometryDocValueReader(CoordinateEncoder.GEO, (ShapeIndexer)new GeoShapeIndexer(Orientation.CCW, "SpatialRelatesFunction"), geometry);
        }
        return SpatialRelatesUtils.asGeometryDocValueReader(CoordinateEncoder.CARTESIAN, (ShapeIndexer)new CartesianShapeIndexer("SpatialRelatesFunction"), geometry);
    }

    static GeometryDocValueReader asGeometryDocValueReader(CoordinateEncoder encoder, ShapeIndexer shapeIndexer, Geometry geometry) throws IOException {
        GeometryDocValueReader reader = new GeometryDocValueReader();
        CentroidCalculator centroidCalculator = new CentroidCalculator();
        if (geometry instanceof Circle) {
            throw new IllegalArgumentException(ShapeType.CIRCLE + " geometry is not supported");
        }
        centroidCalculator.add(geometry);
        reader.reset(GeometryDocValueWriter.write((List)shapeIndexer.indexShape(geometry), (CoordinateEncoder)encoder, (CentroidCalculator)centroidCalculator));
        return reader;
    }

    public static Geometry makeGeometryFromLiteral(Expression expr) {
        Object value = ExpressionTranslators.valueOf((Expression)expr);
        if (value instanceof BytesRef) {
            BytesRef bytesRef = (BytesRef)value;
            return SpatialCoordinateTypes.UNSPECIFIED.wkbToGeometry(bytesRef);
        }
        throw new IllegalArgumentException("Unsupported combination of literal [" + value.getClass().getSimpleName() + "] of type [" + expr.dataType() + "]");
    }
}

