/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.index.mapper.ShapeIndexer;
import org.elasticsearch.lucene.spatial.Component2DVisitor;
import org.elasticsearch.lucene.spatial.CoordinateEncoder;
import org.elasticsearch.lucene.spatial.GeometryDocValueReader;
import org.elasticsearch.lucene.spatial.TriangleTreeVisitor;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.SpatialCoordinateTypes;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.BinarySpatialFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialEvaluatorFactory;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialRelatesUtils;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;

public abstract class SpatialRelatesFunction
extends BinarySpatialFunction
implements EvaluatorMapper,
SpatialEvaluatorFactory.SpatialSourceSupplier {
    protected SpatialRelatesFunction(Source source, Expression left, Expression right, boolean leftDocValues, boolean rightDocValues) {
        super(source, left, right, leftDocValues, rightDocValues, false);
    }

    protected SpatialRelatesFunction(StreamInput in, boolean leftDocValues, boolean rightDocValues) throws IOException {
        super(in, leftDocValues, rightDocValues, false);
    }

    public abstract ShapeField.QueryRelation queryRelation();

    public DataType dataType() {
        return DataType.BOOLEAN;
    }

    public abstract SpatialRelatesFunction withDocValues(Set<FieldAttribute> var1);

    public boolean canPushToSource(Predicate<FieldAttribute> isAggregatable) {
        return SpatialRelatesFunction.isPushableFieldAttribute(this.left(), isAggregatable) && this.right().foldable() || SpatialRelatesFunction.isPushableFieldAttribute(this.right(), isAggregatable) && this.left().foldable();
    }

    private static boolean isPushableFieldAttribute(Expression exp, Predicate<FieldAttribute> isAggregatable) {
        FieldAttribute fa;
        return exp instanceof FieldAttribute && (fa = (FieldAttribute)exp).getExactInfo().hasExact() && isAggregatable.test(fa) && EsqlDataTypes.isSpatial(fa.dataType());
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.children(), this.leftDocValues, this.rightDocValues);
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            SpatialRelatesFunction other = (SpatialRelatesFunction)obj;
            return Objects.equals(other.children(), this.children()) && Objects.equals(other.leftDocValues, this.leftDocValues) && Objects.equals(other.rightDocValues, this.rightDocValues);
        }
        return false;
    }

    abstract Map<SpatialEvaluatorFactory.SpatialEvaluatorKey, SpatialEvaluatorFactory<?, ?>> evaluatorRules();

    public SpatialRelatesFunction surrogate() {
        return this;
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        return SpatialEvaluatorFactory.makeSpatialEvaluator(this, this.evaluatorRules(), toEvaluator);
    }

    public boolean hasFieldAttribute(Set<FieldAttribute> foundAttributes) {
        return this.foundField(this.left(), foundAttributes) || this.foundField(this.right(), foundAttributes);
    }

    protected boolean foundField(Expression expression, Set<FieldAttribute> foundAttributes) {
        FieldAttribute field;
        return expression instanceof FieldAttribute && foundAttributes.contains(field = (FieldAttribute)expression);
    }

    protected static class SpatialRelations
    extends BinarySpatialFunction.BinarySpatialComparator<Boolean> {
        protected final ShapeField.QueryRelation queryRelation;
        protected final ShapeIndexer shapeIndexer;

        protected SpatialRelations(ShapeField.QueryRelation queryRelation, SpatialCoordinateTypes spatialCoordinateType, CoordinateEncoder encoder, ShapeIndexer shapeIndexer) {
            super(spatialCoordinateType, encoder);
            this.queryRelation = queryRelation;
            this.shapeIndexer = shapeIndexer;
        }

        @Override
        protected Boolean compare(BytesRef left, BytesRef right) throws IOException {
            return this.geometryRelatesGeometry(left, right);
        }

        protected boolean geometryRelatesGeometry(BytesRef left, BytesRef right) throws IOException {
            Component2D rightComponent2D = SpatialRelatesUtils.asLuceneComponent2D(this.crsType, this.fromBytesRef(right));
            return this.geometryRelatesGeometry(left, rightComponent2D);
        }

        protected boolean geometryRelatesGeometry(BytesRef left, Component2D rightComponent2D) throws IOException {
            Geometry leftGeom = this.fromBytesRef(left);
            return this.geometryRelatesGeometry(SpatialRelatesUtils.asGeometryDocValueReader(this.coordinateEncoder, this.shapeIndexer, leftGeom), rightComponent2D);
        }

        protected boolean geometryRelatesGeometry(GeometryDocValueReader reader, Component2D rightComponent2D) throws IOException {
            Component2DVisitor visitor = Component2DVisitor.getVisitor((Component2D)rightComponent2D, (ShapeField.QueryRelation)this.queryRelation, (CoordinateEncoder)this.coordinateEncoder);
            reader.visit((TriangleTreeVisitor)visitor);
            return visitor.matches();
        }

        protected boolean pointRelatesGeometry(long encoded, Geometry geometry) {
            Component2D component2D = SpatialRelatesUtils.asLuceneComponent2D(this.crsType, geometry);
            return this.pointRelatesGeometry(encoded, component2D);
        }

        protected boolean pointRelatesGeometry(long encoded, Component2D component2D) {
            Point point = this.spatialCoordinateType.longAsPoint(encoded);
            return this.pointRelatesGeometry(point, component2D);
        }

        protected boolean pointRelatesGeometry(Point point, Component2D component2D) {
            if (this.queryRelation == ShapeField.QueryRelation.CONTAINS) {
                return component2D.withinPoint(point.getX(), point.getY()) == Component2D.WithinRelation.CANDIDATE;
            }
            boolean contains = component2D.contains(point.getX(), point.getY());
            return this.queryRelation == ShapeField.QueryRelation.DISJOINT ? !contains : contains;
        }
    }
}

