/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Warnings;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialIntersects;

public final class SpatialIntersectsCartesianSourceAndSourceEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Warnings warnings;
    private final EvalOperator.ExpressionEvaluator leftValue;
    private final EvalOperator.ExpressionEvaluator rightValue;
    private final DriverContext driverContext;

    public SpatialIntersectsCartesianSourceAndSourceEvaluator(Source source, EvalOperator.ExpressionEvaluator leftValue, EvalOperator.ExpressionEvaluator rightValue, DriverContext driverContext) {
        this.leftValue = leftValue;
        this.rightValue = rightValue;
        this.driverContext = driverContext;
        this.warnings = Warnings.createWarnings(driverContext.warningsMode(), source);
    }

    public Block eval(Page page) {
        try (BytesRefBlock leftValueBlock = (BytesRefBlock)this.leftValue.eval(page);){
            BooleanBlock booleanBlock;
            block20: {
                BytesRefVector rightValueVector;
                BytesRefVector leftValueVector;
                BytesRefBlock rightValueBlock;
                block18: {
                    BooleanBlock booleanBlock2;
                    block19: {
                        block16: {
                            BooleanBlock booleanBlock3;
                            block17: {
                                rightValueBlock = (BytesRefBlock)this.rightValue.eval(page);
                                try {
                                    leftValueVector = leftValueBlock.asVector();
                                    if (leftValueVector != null) break block16;
                                    booleanBlock3 = this.eval(page.getPositionCount(), leftValueBlock, rightValueBlock);
                                    if (rightValueBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (rightValueBlock != null) {
                                        try {
                                            rightValueBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                rightValueBlock.close();
                            }
                            return booleanBlock3;
                        }
                        rightValueVector = rightValueBlock.asVector();
                        if (rightValueVector != null) break block18;
                        booleanBlock2 = this.eval(page.getPositionCount(), leftValueBlock, rightValueBlock);
                        if (rightValueBlock == null) break block19;
                        rightValueBlock.close();
                    }
                    return booleanBlock2;
                }
                booleanBlock = this.eval(page.getPositionCount(), leftValueVector, rightValueVector);
                if (rightValueBlock == null) break block20;
                rightValueBlock.close();
            }
            return booleanBlock;
        }
    }

    public BooleanBlock eval(int positionCount, BytesRefBlock leftValueBlock, BytesRefBlock rightValueBlock) {
        try (BooleanBlock.Builder result = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);){
            BytesRef leftValueScratch = new BytesRef();
            BytesRef rightValueScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                if (leftValueBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (leftValueBlock.getValueCount(p) != 1) {
                    if (leftValueBlock.getValueCount(p) > 1) {
                        this.warnings.registerException(new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                if (rightValueBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (rightValueBlock.getValueCount(p) != 1) {
                    if (rightValueBlock.getValueCount(p) > 1) {
                        this.warnings.registerException(new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                try {
                    result.appendBoolean(SpatialIntersects.processCartesianSourceAndSource(leftValueBlock.getBytesRef(leftValueBlock.getFirstValueIndex(p), leftValueScratch), rightValueBlock.getBytesRef(rightValueBlock.getFirstValueIndex(p), rightValueScratch)));
                    continue;
                }
                catch (IOException | IllegalArgumentException e) {
                    this.warnings.registerException(e);
                    result.appendNull();
                }
            }
            BooleanBlock booleanBlock = result.build();
            return booleanBlock;
        }
    }

    public BooleanBlock eval(int positionCount, BytesRefVector leftValueVector, BytesRefVector rightValueVector) {
        try (BooleanBlock.Builder result = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);){
            BytesRef leftValueScratch = new BytesRef();
            BytesRef rightValueScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                try {
                    result.appendBoolean(SpatialIntersects.processCartesianSourceAndSource(leftValueVector.getBytesRef(p, leftValueScratch), rightValueVector.getBytesRef(p, rightValueScratch)));
                    continue;
                }
                catch (IOException | IllegalArgumentException e) {
                    this.warnings.registerException(e);
                    result.appendNull();
                }
            }
            BooleanBlock booleanBlock = result.build();
            return booleanBlock;
        }
    }

    public String toString() {
        return "SpatialIntersectsCartesianSourceAndSourceEvaluator[leftValue=" + this.leftValue + ", rightValue=" + this.rightValue + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.leftValue, this.rightValue});
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory leftValue;
        private final EvalOperator.ExpressionEvaluator.Factory rightValue;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory leftValue, EvalOperator.ExpressionEvaluator.Factory rightValue) {
            this.source = source;
            this.leftValue = leftValue;
            this.rightValue = rightValue;
        }

        public SpatialIntersectsCartesianSourceAndSourceEvaluator get(DriverContext context) {
            return new SpatialIntersectsCartesianSourceAndSourceEvaluator(this.source, this.leftValue.get(context), this.rightValue.get(context), context);
        }

        public String toString() {
            return "SpatialIntersectsCartesianSourceAndSourceEvaluator[leftValue=" + this.leftValue + ", rightValue=" + this.rightValue + "]";
        }
    }
}

