/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.common.geo.Orientation;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.index.mapper.GeoShapeIndexer;
import org.elasticsearch.index.mapper.ShapeIndexer;
import org.elasticsearch.lucene.spatial.CartesianShapeIndexer;
import org.elasticsearch.lucene.spatial.CoordinateEncoder;
import org.elasticsearch.lucene.spatial.GeometryDocValueReader;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.SpatialCoordinateTypes;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.BinarySpatialFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialContainsCartesianPointDocValuesAndConstantEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialContainsCartesianPointDocValuesAndSourceEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialContainsCartesianSourceAndConstantEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialContainsCartesianSourceAndSourceEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialContainsGeoPointDocValuesAndConstantEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialContainsGeoPointDocValuesAndSourceEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialContainsGeoSourceAndConstantEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialContainsGeoSourceAndSourceEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialEvaluatorFactory;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialRelatesFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialRelatesUtils;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialWithin;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;

public class SpatialContains
extends SpatialRelatesFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "SpatialContains", SpatialContains::new);
    public static final SpatialRelationsContains GEO = new SpatialRelationsContains(SpatialCoordinateTypes.GEO, CoordinateEncoder.GEO, (ShapeIndexer)new GeoShapeIndexer(Orientation.CCW, "ST_Contains"));
    public static final SpatialRelationsContains CARTESIAN = new SpatialRelationsContains(SpatialCoordinateTypes.CARTESIAN, CoordinateEncoder.CARTESIAN, (ShapeIndexer)new CartesianShapeIndexer("ST_Contains"));
    private static final Map<SpatialEvaluatorFactory.SpatialEvaluatorKey, SpatialEvaluatorFactory<?, ?>> evaluatorMap = new HashMap();

    @FunctionInfo(returnType={"boolean"}, description="Returns whether the first geometry contains the second geometry.\nThis is the inverse of the <<esql-st_within,ST_WITHIN>> function.", examples={@Example(file="spatial_shapes", tag="st_contains-airport_city_boundaries")})
    public SpatialContains(Source source, @Param(name="geomA", type={"geo_point", "cartesian_point", "geo_shape", "cartesian_shape"}, description="Expression of type `geo_point`, `cartesian_point`, `geo_shape` or `cartesian_shape`.\nIf `null`, the function returns `null`.") Expression left, @Param(name="geomB", type={"geo_point", "cartesian_point", "geo_shape", "cartesian_shape"}, description="Expression of type `geo_point`, `cartesian_point`, `geo_shape` or `cartesian_shape`.\nIf `null`, the function returns `null`.\nThe second parameter must also have the same coordinate system as the first.\nThis means it is not possible to combine `geo_*` and `cartesian_*` parameters.") Expression right) {
        this(source, left, right, false, false);
    }

    SpatialContains(Source source, Expression left, Expression right, boolean leftDocValues, boolean rightDocValues) {
        super(source, left, right, leftDocValues, rightDocValues);
    }

    private SpatialContains(StreamInput in) throws IOException {
        super(in, false, false);
    }

    public String getWriteableName() {
        return SpatialContains.ENTRY.name;
    }

    @Override
    public ShapeField.QueryRelation queryRelation() {
        return ShapeField.QueryRelation.CONTAINS;
    }

    @Override
    public SpatialContains withDocValues(Set<FieldAttribute> attributes) {
        boolean leftDV = this.leftDocValues || this.foundField(this.left(), attributes);
        boolean rightDV = this.rightDocValues || this.foundField(this.right(), attributes);
        return new SpatialContains(this.source(), this.left(), this.right(), leftDV, rightDV);
    }

    protected SpatialContains replaceChildren(Expression newLeft, Expression newRight) {
        return new SpatialContains(this.source(), newLeft, newRight, this.leftDocValues, this.rightDocValues);
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, SpatialContains::new, (Object)this.left(), (Object)this.right());
    }

    @Override
    public Object fold() {
        try {
            GeometryDocValueReader docValueReader = SpatialRelatesUtils.asGeometryDocValueReader(this.crsType, this.left());
            Geometry rightGeom = SpatialRelatesUtils.makeGeometryFromLiteral(this.right());
            Component2D[] components = SpatialRelatesUtils.asLuceneComponent2Ds(this.crsType, rightGeom);
            return this.crsType == BinarySpatialFunction.SpatialCrsType.GEO ? GEO.geometryRelatesGeometries(docValueReader, components) : CARTESIAN.geometryRelatesGeometries(docValueReader, components);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to fold constant fields: " + e.getMessage(), e);
        }
    }

    @Override
    Map<SpatialEvaluatorFactory.SpatialEvaluatorKey, SpatialEvaluatorFactory<?, ?>> evaluatorRules() {
        return evaluatorMap;
    }

    @Override
    public SpatialRelatesFunction surrogate() {
        if (this.left().foldable() && !this.right().foldable()) {
            return new SpatialWithin(this.source(), this.right(), this.left(), this.rightDocValues, this.leftDocValues);
        }
        return this;
    }

    static boolean processGeoSourceAndConstant(BytesRef leftValue, Component2D[] rightValue) throws IOException {
        return GEO.geometryRelatesGeometries(leftValue, rightValue);
    }

    static boolean processGeoSourceAndSource(BytesRef leftValue, BytesRef rightValue) throws IOException {
        return GEO.geometryRelatesGeometry(leftValue, rightValue);
    }

    static boolean processGeoPointDocValuesAndConstant(long leftValue, Component2D[] rightValue) {
        return GEO.pointRelatesGeometries(leftValue, rightValue);
    }

    static boolean processGeoPointDocValuesAndSource(long leftValue, BytesRef rightValue) {
        Geometry geometry = SpatialCoordinateTypes.UNSPECIFIED.wkbToGeometry(rightValue);
        return GEO.pointRelatesGeometry(leftValue, geometry);
    }

    static boolean processCartesianSourceAndConstant(BytesRef leftValue, Component2D[] rightValue) throws IOException {
        return CARTESIAN.geometryRelatesGeometries(leftValue, rightValue);
    }

    static boolean processCartesianSourceAndSource(BytesRef leftValue, BytesRef rightValue) throws IOException {
        return CARTESIAN.geometryRelatesGeometry(leftValue, rightValue);
    }

    static boolean processCartesianPointDocValuesAndConstant(long leftValue, Component2D[] rightValue) {
        return CARTESIAN.pointRelatesGeometries(leftValue, rightValue);
    }

    static boolean processCartesianPointDocValuesAndSource(long leftValue, BytesRef rightValue) {
        Geometry geometry = SpatialCoordinateTypes.UNSPECIFIED.wkbToGeometry(rightValue);
        return CARTESIAN.pointRelatesGeometry(leftValue, geometry);
    }

    static {
        for (DataType spatialType : new DataType[]{DataType.GEO_POINT, DataType.GEO_SHAPE}) {
            for (DataType otherType : new DataType[]{DataType.GEO_POINT, DataType.GEO_SHAPE}) {
                evaluatorMap.put(SpatialEvaluatorFactory.SpatialEvaluatorKey.fromSources(spatialType, otherType), new SpatialEvaluatorFactory.SpatialEvaluatorFactoryWithFields((TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)SpatialContainsGeoSourceAndSourceEvaluator.Factory::new)));
                evaluatorMap.put(SpatialEvaluatorFactory.SpatialEvaluatorKey.fromSourceAndConstant(spatialType, otherType), new SpatialEvaluatorFactory.SpatialEvaluatorWithConstantArrayFactory((TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, Component2D[], EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)SpatialContainsGeoSourceAndConstantEvaluator.Factory::new)));
                if (!EsqlDataTypes.isSpatialPoint(spatialType)) continue;
                evaluatorMap.put(SpatialEvaluatorFactory.SpatialEvaluatorKey.fromSources(spatialType, otherType).withLeftDocValues(), new SpatialEvaluatorFactory.SpatialEvaluatorFactoryWithFields((TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)SpatialContainsGeoPointDocValuesAndSourceEvaluator.Factory::new)));
                evaluatorMap.put(SpatialEvaluatorFactory.SpatialEvaluatorKey.fromSourceAndConstant(spatialType, otherType).withLeftDocValues(), new SpatialEvaluatorFactory.SpatialEvaluatorWithConstantArrayFactory((TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, Component2D[], EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)SpatialContainsGeoPointDocValuesAndConstantEvaluator.Factory::new)));
            }
        }
        for (DataType spatialType : new DataType[]{DataType.CARTESIAN_POINT, DataType.CARTESIAN_SHAPE}) {
            for (DataType otherType : new DataType[]{DataType.CARTESIAN_POINT, DataType.CARTESIAN_SHAPE}) {
                evaluatorMap.put(SpatialEvaluatorFactory.SpatialEvaluatorKey.fromSources(spatialType, otherType), new SpatialEvaluatorFactory.SpatialEvaluatorFactoryWithFields((TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)SpatialContainsCartesianSourceAndSourceEvaluator.Factory::new)));
                evaluatorMap.put(SpatialEvaluatorFactory.SpatialEvaluatorKey.fromSourceAndConstant(spatialType, otherType), new SpatialEvaluatorFactory.SpatialEvaluatorWithConstantArrayFactory((TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, Component2D[], EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)SpatialContainsCartesianSourceAndConstantEvaluator.Factory::new)));
                if (!EsqlDataTypes.isSpatialPoint(spatialType)) continue;
                evaluatorMap.put(SpatialEvaluatorFactory.SpatialEvaluatorKey.fromSources(spatialType, otherType).withLeftDocValues(), new SpatialEvaluatorFactory.SpatialEvaluatorFactoryWithFields((TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)SpatialContainsCartesianPointDocValuesAndSourceEvaluator.Factory::new)));
                evaluatorMap.put(SpatialEvaluatorFactory.SpatialEvaluatorKey.fromSourceAndConstant(spatialType, otherType).withLeftDocValues(), new SpatialEvaluatorFactory.SpatialEvaluatorWithConstantArrayFactory((TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, Component2D[], EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)SpatialContainsCartesianPointDocValuesAndConstantEvaluator.Factory::new)));
            }
        }
    }

    static final class SpatialRelationsContains
    extends SpatialRelatesFunction.SpatialRelations {
        SpatialRelationsContains(SpatialCoordinateTypes spatialCoordinateType, CoordinateEncoder encoder, ShapeIndexer shapeIndexer) {
            super(ShapeField.QueryRelation.CONTAINS, spatialCoordinateType, encoder, shapeIndexer);
        }

        @Override
        protected boolean geometryRelatesGeometry(BytesRef left, BytesRef right) throws IOException {
            Component2D[] rightComponent2Ds = SpatialRelatesUtils.asLuceneComponent2Ds(this.crsType, this.fromBytesRef(right));
            return this.geometryRelatesGeometries(left, rightComponent2Ds);
        }

        private boolean geometryRelatesGeometries(BytesRef left, Component2D[] rightComponent2Ds) throws IOException {
            Geometry leftGeom = this.fromBytesRef(left);
            GeometryDocValueReader leftDocValueReader = SpatialRelatesUtils.asGeometryDocValueReader(this.coordinateEncoder, this.shapeIndexer, leftGeom);
            return this.geometryRelatesGeometries(leftDocValueReader, rightComponent2Ds);
        }

        private boolean geometryRelatesGeometries(GeometryDocValueReader leftDocValueReader, Component2D[] rightComponent2Ds) throws IOException {
            for (Component2D rightComponent2D : rightComponent2Ds) {
                if (this.geometryRelatesGeometry(leftDocValueReader, rightComponent2D)) continue;
                return false;
            }
            return true;
        }

        private boolean pointRelatesGeometries(long encoded, Component2D[] rightComponent2Ds) {
            Point point = this.spatialCoordinateType.longAsPoint(encoded);
            for (Component2D rightComponent2D : rightComponent2Ds) {
                if (this.pointRelatesGeometry(point, rightComponent2D)) continue;
                return false;
            }
            return true;
        }
    }
}

