/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.AbstractMultivalueFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvLastBooleanEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvLastBytesRefEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvLastDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvLastIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvLastLongEvaluator;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;

public class MvLast
extends AbstractMultivalueFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "MvLast", MvLast::new);

    @FunctionInfo(returnType={"boolean", "cartesian_point", "cartesian_shape", "date", "double", "geo_point", "geo_shape", "integer", "ip", "keyword", "long", "text", "unsigned_long", "version"}, description="Converts a multivalue expression into a single valued column containing the last\nvalue. This is most useful when reading from a function that emits multivalued\ncolumns in a known order like <<esql-split>>.\n\nThe order that <<esql-multivalued-fields, multivalued fields>> are read from\nunderlying storage is not guaranteed. It is *frequently* ascending, but don't\nrely on that. If you need the maximum value use <<esql-mv_max>> instead of\n`MV_LAST`. `MV_MAX` has optimizations for sorted values so there isn't a\nperformance benefit to `MV_LAST`.", examples={@Example(file="string", tag="mv_last")})
    public MvLast(Source source, @Param(name="field", type={"boolean", "cartesian_point", "cartesian_shape", "date", "double", "geo_point", "geo_shape", "integer", "ip", "keyword", "long", "text", "unsigned_long", "version"}, description="Multivalue expression.") Expression field) {
        super(source, field);
    }

    private MvLast(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return MvLast.ENTRY.name;
    }

    @Override
    protected Expression.TypeResolution resolveFieldType() {
        return TypeResolutions.isType((Expression)this.field(), EsqlDataTypes::isRepresentable, (String)this.sourceText(), null, (String[])new String[]{"representable"});
    }

    @Override
    protected EvalOperator.ExpressionEvaluator.Factory evaluator(EvalOperator.ExpressionEvaluator.Factory fieldEval) {
        return switch (PlannerUtils.toElementType(this.field().dataType())) {
            case ElementType.BOOLEAN -> new MvLastBooleanEvaluator.Factory(fieldEval);
            case ElementType.BYTES_REF -> new MvLastBytesRefEvaluator.Factory(fieldEval);
            case ElementType.DOUBLE -> new MvLastDoubleEvaluator.Factory(fieldEval);
            case ElementType.INT -> new MvLastIntEvaluator.Factory(fieldEval);
            case ElementType.LONG -> new MvLastLongEvaluator.Factory(fieldEval);
            case ElementType.NULL -> EvalOperator.CONSTANT_NULL_FACTORY;
            default -> throw EsqlIllegalArgumentException.illegalDataType(this.field.dataType());
        };
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new MvLast(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, MvLast::new, (Object)this.field());
    }

    static boolean process(BooleanBlock block, int start, int end) {
        return block.getBoolean(end - 1);
    }

    static long process(LongBlock block, int start, int end) {
        return block.getLong(end - 1);
    }

    static int process(IntBlock block, int start, int end) {
        return block.getInt(end - 1);
    }

    static double process(DoubleBlock block, int start, int end) {
        return block.getDouble(end - 1);
    }

    static BytesRef process(BytesRefBlock block, int start, int end, BytesRef scratch) {
        return block.getBytesRef(end - 1, scratch);
    }
}

