/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Warnings;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvAppend;

public final class MvAppendBooleanEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Warnings warnings;
    private final EvalOperator.ExpressionEvaluator field1;
    private final EvalOperator.ExpressionEvaluator field2;
    private final DriverContext driverContext;

    public MvAppendBooleanEvaluator(Source source, EvalOperator.ExpressionEvaluator field1, EvalOperator.ExpressionEvaluator field2, DriverContext driverContext) {
        this.field1 = field1;
        this.field2 = field2;
        this.driverContext = driverContext;
        this.warnings = Warnings.createWarnings(driverContext.warningsMode(), source);
    }

    public Block eval(Page page) {
        try (BooleanBlock field1Block = (BooleanBlock)this.field1.eval(page);){
            BooleanBlock booleanBlock;
            block12: {
                BooleanBlock field2Block = (BooleanBlock)this.field2.eval(page);
                try {
                    booleanBlock = this.eval(page.getPositionCount(), field1Block, field2Block);
                    if (field2Block == null) break block12;
                }
                catch (Throwable throwable) {
                    if (field2Block != null) {
                        try {
                            field2Block.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                field2Block.close();
            }
            return booleanBlock;
        }
    }

    public BooleanBlock eval(int positionCount, BooleanBlock field1Block, BooleanBlock field2Block) {
        try (BooleanBlock.Builder result = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                boolean allBlocksAreNulls = true;
                if (!field1Block.isNull(p)) {
                    allBlocksAreNulls = false;
                }
                if (!field2Block.isNull(p)) {
                    allBlocksAreNulls = false;
                }
                if (allBlocksAreNulls) {
                    result.appendNull();
                    continue;
                }
                MvAppend.process(result, p, field1Block, field2Block);
            }
            BooleanBlock booleanBlock = result.build();
            return booleanBlock;
        }
    }

    public String toString() {
        return "MvAppendBooleanEvaluator[field1=" + this.field1 + ", field2=" + this.field2 + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.field1, this.field2});
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory field1;
        private final EvalOperator.ExpressionEvaluator.Factory field2;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory field1, EvalOperator.ExpressionEvaluator.Factory field2) {
            this.source = source;
            this.field1 = field1;
            this.field2 = field2;
        }

        public MvAppendBooleanEvaluator get(DriverContext context) {
            return new MvAppendBooleanEvaluator(this.source, this.field1.get(context), this.field2.get(context), context);
        }

        public String toString() {
            return "MvAppendBooleanEvaluator[field1=" + this.field1 + ", field2=" + this.field2 + "]";
        }
    }
}

