/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.NumericUtils;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Cast;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.PowEvaluator;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public class Pow
extends EsqlScalarFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Pow", Pow::new);
    private final Expression base;
    private final Expression exponent;

    @FunctionInfo(returnType={"double"}, description="Returns the value of `base` raised to the power of `exponent`.", note="It is still possible to overflow a double result here; in that case, null will be returned.", examples={@Example(file="math", tag="powDI"), @Example(file="math", tag="powID-sqrt", description="The exponent can be a fraction, which is similar to performing a root.\nFor example, the exponent of `0.5` will give the square root of the base:")})
    public Pow(Source source, @Param(name="base", type={"double", "integer", "long", "unsigned_long"}, description="Numeric expression for the base. If `null`, the function returns `null`.") Expression base, @Param(name="exponent", type={"double", "integer", "long", "unsigned_long"}, description="Numeric expression for the exponent. If `null`, the function returns `null`.") Expression exponent) {
        super(source, Arrays.asList(base, exponent));
        this.base = base;
        this.exponent = exponent;
    }

    private Pow(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.base);
        out.writeNamedWriteable((NamedWriteable)this.exponent);
    }

    public String getWriteableName() {
        return Pow.ENTRY.name;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isNumeric((Expression)this.base, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        return TypeResolutions.isNumeric((Expression)this.exponent, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND);
    }

    public boolean foldable() {
        return this.base.foldable() && this.exponent.foldable();
    }

    static double process(double base, double exponent) {
        return NumericUtils.asFiniteNumber((double)Math.pow(base, exponent));
    }

    public final Expression replaceChildren(List<Expression> newChildren) {
        return new Pow(this.source(), newChildren.get(0), newChildren.get(1));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Pow::new, (Object)this.base(), (Object)this.exponent());
    }

    public Expression base() {
        return this.base;
    }

    public Expression exponent() {
        return this.exponent;
    }

    public DataType dataType() {
        return DataType.DOUBLE;
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory baseEval = Cast.cast(this.source(), this.base.dataType(), DataType.DOUBLE, toEvaluator.apply(this.base));
        EvalOperator.ExpressionEvaluator.Factory expEval = Cast.cast(this.source(), this.exponent.dataType(), DataType.DOUBLE, toEvaluator.apply(this.exponent));
        return new PowEvaluator.Factory(this.source(), baseEval, expEval);
    }
}

