/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Warnings;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Log;

public final class LogConstantEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Warnings warnings;
    private final EvalOperator.ExpressionEvaluator value;
    private final DriverContext driverContext;

    public LogConstantEvaluator(Source source, EvalOperator.ExpressionEvaluator value, DriverContext driverContext) {
        this.value = value;
        this.driverContext = driverContext;
        this.warnings = Warnings.createWarnings(driverContext.warningsMode(), source);
    }

    public Block eval(Page page) {
        try (DoubleBlock valueBlock = (DoubleBlock)this.value.eval(page);){
            DoubleVector valueVector = valueBlock.asVector();
            if (valueVector == null) {
                DoubleBlock doubleBlock = this.eval(page.getPositionCount(), valueBlock);
                return doubleBlock;
            }
            DoubleBlock doubleBlock = this.eval(page.getPositionCount(), valueVector);
            return doubleBlock;
        }
    }

    public DoubleBlock eval(int positionCount, DoubleBlock valueBlock) {
        try (DoubleBlock.Builder result = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (valueBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (valueBlock.getValueCount(p) != 1) {
                    if (valueBlock.getValueCount(p) > 1) {
                        this.warnings.registerException(new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                try {
                    result.appendDouble(Log.process(valueBlock.getDouble(valueBlock.getFirstValueIndex(p))));
                    continue;
                }
                catch (ArithmeticException e) {
                    this.warnings.registerException(e);
                    result.appendNull();
                }
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public DoubleBlock eval(int positionCount, DoubleVector valueVector) {
        try (DoubleBlock.Builder result = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                try {
                    result.appendDouble(Log.process(valueVector.getDouble(p)));
                    continue;
                }
                catch (ArithmeticException e) {
                    this.warnings.registerException(e);
                    result.appendNull();
                }
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public String toString() {
        return "LogConstantEvaluator[value=" + this.value + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.value);
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory value;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory value) {
            this.source = source;
            this.value = value;
        }

        public LogConstantEvaluator get(DriverContext context) {
            return new LogConstantEvaluator(this.source, this.value.get(context), context);
        }

        public String toString() {
            return "LogConstantEvaluator[value=" + this.value + "]";
        }
    }
}

