/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.FloorDoubleEvaluator;

public class Floor
extends UnaryScalarFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Floor", Floor::new);

    @FunctionInfo(returnType={"double", "integer", "long", "unsigned_long"}, description="Round a number down to the nearest integer.", note="This is a noop for `long` (including unsigned) and `integer`.\nFor `double` this picks the closest `double` value to the integer\nsimilar to {javadoc}/java.base/java/lang/Math.html#floor(double)[Math.floor].", examples={@Example(file="math", tag="floor")})
    public Floor(Source source, @Param(name="number", type={"double", "integer", "long", "unsigned_long"}, description="Numeric expression. If `null`, the function returns `null`.") Expression n) {
        super(source, n);
    }

    private Floor(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return Floor.ENTRY.name;
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        if (this.dataType().isWholeNumber()) {
            return toEvaluator.apply(this.field());
        }
        return new FloorDoubleEvaluator.Factory(this.source(), toEvaluator.apply(this.field()));
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isNumeric((Expression)this.field, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT);
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Floor(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Floor::new, (Object)this.field());
    }

    static double process(double val) {
        return Math.floor(val);
    }
}

