/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.AbstractTrigonometricFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.CoshEvaluator;

public class Cosh
extends AbstractTrigonometricFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Cosh", Cosh::new);

    @FunctionInfo(returnType={"double"}, description="Returns the {wikipedia}/Hyperbolic_functions[hyperbolic cosine] of an angle.", examples={@Example(file="floats", tag="cosh")})
    public Cosh(Source source, @Param(name="angle", type={"double", "integer", "long", "unsigned_long"}, description="An angle, in radians. If `null`, the function returns `null`.") Expression angle) {
        super(source, angle);
    }

    private Cosh(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return Cosh.ENTRY.name;
    }

    @Override
    protected EvalOperator.ExpressionEvaluator.Factory doubleEvaluator(EvalOperator.ExpressionEvaluator.Factory field) {
        return new CoshEvaluator.Factory(this.source(), field);
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Cosh(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Cosh::new, (Object)this.field());
    }

    static double process(double val) {
        double res = Math.cosh(val);
        if (Double.isNaN(res) || Double.isInfinite(res)) {
            throw new ArithmeticException("cosh overflow");
        }
        return res;
    }
}

