/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.CbrtDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.CbrtIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.CbrtLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.CbrtUnsignedLongEvaluator;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public class Cbrt
extends UnaryScalarFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Cbrt", Cbrt::new);

    @FunctionInfo(returnType={"double"}, description="Returns the cube root of a number. The input can be any numeric value, the return value is always a double.\nCube roots of infinities are null.", examples={@Example(file="math", tag="cbrt")})
    public Cbrt(Source source, @Param(name="number", type={"double", "integer", "long", "unsigned_long"}, description="Numeric expression. If `null`, the function returns `null`.") Expression n) {
        super(source, n);
    }

    private Cbrt(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return Cbrt.ENTRY.name;
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory field = toEvaluator.apply(this.field());
        DataType fieldType = this.field().dataType();
        if (fieldType == DataType.DOUBLE) {
            return new CbrtDoubleEvaluator.Factory(this.source(), field);
        }
        if (fieldType == DataType.INTEGER) {
            return new CbrtIntEvaluator.Factory(this.source(), field);
        }
        if (fieldType == DataType.LONG) {
            return new CbrtLongEvaluator.Factory(this.source(), field);
        }
        if (fieldType == DataType.UNSIGNED_LONG) {
            return new CbrtUnsignedLongEvaluator.Factory(this.source(), field);
        }
        throw EsqlIllegalArgumentException.illegalDataType(fieldType);
    }

    static double process(double val) {
        return Math.cbrt(val);
    }

    static double process(long val) {
        return Math.cbrt(val);
    }

    static double processUnsignedLong(long val) {
        return Math.cbrt(EsqlDataTypeConverter.unsignedLongToDouble(val));
    }

    static double process(int val) {
        return Math.cbrt(val);
    }

    public final Expression replaceChildren(List<Expression> newChildren) {
        return new Cbrt(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Cbrt::new, (Object)this.field());
    }

    @Override
    public DataType dataType() {
        return DataType.DOUBLE;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isNumeric((Expression)this.field, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT);
    }
}

