/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Warnings;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Cast;

public final class CastIntToLongEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Warnings warnings;
    private final EvalOperator.ExpressionEvaluator v;
    private final DriverContext driverContext;

    public CastIntToLongEvaluator(Source source, EvalOperator.ExpressionEvaluator v, DriverContext driverContext) {
        this.v = v;
        this.driverContext = driverContext;
        this.warnings = Warnings.createWarnings(driverContext.warningsMode(), source);
    }

    public Block eval(Page page) {
        try (IntBlock vBlock = (IntBlock)this.v.eval(page);){
            IntVector vVector = vBlock.asVector();
            if (vVector == null) {
                LongBlock longBlock = this.eval(page.getPositionCount(), vBlock);
                return longBlock;
            }
            LongBlock longBlock = this.eval(page.getPositionCount(), vVector).asBlock();
            return longBlock;
        }
    }

    public LongBlock eval(int positionCount, IntBlock vBlock) {
        try (LongBlock.Builder result = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (vBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (vBlock.getValueCount(p) != 1) {
                    if (vBlock.getValueCount(p) > 1) {
                        this.warnings.registerException(new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                result.appendLong(Cast.castIntToLong(vBlock.getInt(vBlock.getFirstValueIndex(p))));
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public LongVector eval(int positionCount, IntVector vVector) {
        try (LongVector.FixedBuilder result = this.driverContext.blockFactory().newLongVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                result.appendLong(p, Cast.castIntToLong(vVector.getInt(p)));
            }
            LongVector longVector = result.build();
            return longVector;
        }
    }

    public String toString() {
        return "CastIntToLongEvaluator[v=" + this.v + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.v);
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory v;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory v) {
            this.source = source;
            this.v = v;
        }

        public CastIntToLongEvaluator get(DriverContext context) {
            return new CastIntToLongEvaluator(this.source, this.v.get(context), context);
        }

        public String toString() {
            return "CastIntToLongEvaluator[v=" + this.v + "]";
        }
    }
}

