/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Warnings;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Cast;

public final class CastIntToDoubleEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Warnings warnings;
    private final EvalOperator.ExpressionEvaluator v;
    private final DriverContext driverContext;

    public CastIntToDoubleEvaluator(Source source, EvalOperator.ExpressionEvaluator v, DriverContext driverContext) {
        this.v = v;
        this.driverContext = driverContext;
        this.warnings = Warnings.createWarnings(driverContext.warningsMode(), source);
    }

    public Block eval(Page page) {
        try (IntBlock vBlock = (IntBlock)this.v.eval(page);){
            IntVector vVector = vBlock.asVector();
            if (vVector == null) {
                DoubleBlock doubleBlock = this.eval(page.getPositionCount(), vBlock);
                return doubleBlock;
            }
            DoubleBlock doubleBlock = this.eval(page.getPositionCount(), vVector).asBlock();
            return doubleBlock;
        }
    }

    public DoubleBlock eval(int positionCount, IntBlock vBlock) {
        try (DoubleBlock.Builder result = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (vBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (vBlock.getValueCount(p) != 1) {
                    if (vBlock.getValueCount(p) > 1) {
                        this.warnings.registerException(new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                result.appendDouble(Cast.castIntToDouble(vBlock.getInt(vBlock.getFirstValueIndex(p))));
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public DoubleVector eval(int positionCount, IntVector vVector) {
        try (DoubleVector.FixedBuilder result = this.driverContext.blockFactory().newDoubleVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                result.appendDouble(p, Cast.castIntToDouble(vVector.getInt(p)));
            }
            DoubleVector doubleVector = result.build();
            return doubleVector;
        }
    }

    public String toString() {
        return "CastIntToDoubleEvaluator[v=" + this.v + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.v);
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory v;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory v) {
            this.source = source;
            this.v = v;
        }

        public CastIntToDoubleEvaluator get(DriverContext context) {
            return new CastIntToDoubleEvaluator(this.source, this.v.get(context), context);
        }

        public String toString() {
            return "CastIntToDoubleEvaluator[v=" + this.v + "]";
        }
    }
}

