/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import org.elasticsearch.common.Rounding;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Warnings;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateTrunc;

public final class DateTruncEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Warnings warnings;
    private final EvalOperator.ExpressionEvaluator fieldVal;
    private final Rounding.Prepared rounding;
    private final DriverContext driverContext;

    public DateTruncEvaluator(Source source, EvalOperator.ExpressionEvaluator fieldVal, Rounding.Prepared rounding, DriverContext driverContext) {
        this.fieldVal = fieldVal;
        this.rounding = rounding;
        this.driverContext = driverContext;
        this.warnings = Warnings.createWarnings(driverContext.warningsMode(), source);
    }

    public Block eval(Page page) {
        try (LongBlock fieldValBlock = (LongBlock)this.fieldVal.eval(page);){
            LongVector fieldValVector = fieldValBlock.asVector();
            if (fieldValVector == null) {
                LongBlock longBlock = this.eval(page.getPositionCount(), fieldValBlock);
                return longBlock;
            }
            LongBlock longBlock = this.eval(page.getPositionCount(), fieldValVector).asBlock();
            return longBlock;
        }
    }

    public LongBlock eval(int positionCount, LongBlock fieldValBlock) {
        try (LongBlock.Builder result = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (fieldValBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (fieldValBlock.getValueCount(p) != 1) {
                    if (fieldValBlock.getValueCount(p) > 1) {
                        this.warnings.registerException(new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                result.appendLong(DateTrunc.process(fieldValBlock.getLong(fieldValBlock.getFirstValueIndex(p)), this.rounding));
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public LongVector eval(int positionCount, LongVector fieldValVector) {
        try (LongVector.FixedBuilder result = this.driverContext.blockFactory().newLongVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                result.appendLong(p, DateTrunc.process(fieldValVector.getLong(p), this.rounding));
            }
            LongVector longVector = result.build();
            return longVector;
        }
    }

    public String toString() {
        return "DateTruncEvaluator[fieldVal=" + this.fieldVal + ", rounding=" + this.rounding + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.fieldVal);
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory fieldVal;
        private final Rounding.Prepared rounding;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory fieldVal, Rounding.Prepared rounding) {
            this.source = source;
            this.fieldVal = fieldVal;
            this.rounding = rounding;
        }

        public DateTruncEvaluator get(DriverContext context) {
            return new DateTruncEvaluator(this.source, this.fieldVal.get(context), this.rounding, context);
        }

        public String toString() {
            return "DateTruncEvaluator[fieldVal=" + this.fieldVal + ", rounding=" + this.rounding + "]";
        }
    }
}

