/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import java.time.ZoneId;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Warnings;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateExtract;

public final class DateExtractEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Warnings warnings;
    private final EvalOperator.ExpressionEvaluator value;
    private final EvalOperator.ExpressionEvaluator chronoField;
    private final ZoneId zone;
    private final DriverContext driverContext;

    public DateExtractEvaluator(Source source, EvalOperator.ExpressionEvaluator value, EvalOperator.ExpressionEvaluator chronoField, ZoneId zone, DriverContext driverContext) {
        this.value = value;
        this.chronoField = chronoField;
        this.zone = zone;
        this.driverContext = driverContext;
        this.warnings = Warnings.createWarnings(driverContext.warningsMode(), source);
    }

    public Block eval(Page page) {
        try (LongBlock valueBlock = (LongBlock)this.value.eval(page);){
            LongBlock longBlock;
            block20: {
                BytesRefVector chronoFieldVector;
                LongVector valueVector;
                BytesRefBlock chronoFieldBlock;
                block18: {
                    LongBlock longBlock2;
                    block19: {
                        block16: {
                            LongBlock longBlock3;
                            block17: {
                                chronoFieldBlock = (BytesRefBlock)this.chronoField.eval(page);
                                try {
                                    valueVector = valueBlock.asVector();
                                    if (valueVector != null) break block16;
                                    longBlock3 = this.eval(page.getPositionCount(), valueBlock, chronoFieldBlock);
                                    if (chronoFieldBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (chronoFieldBlock != null) {
                                        try {
                                            chronoFieldBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                chronoFieldBlock.close();
                            }
                            return longBlock3;
                        }
                        chronoFieldVector = chronoFieldBlock.asVector();
                        if (chronoFieldVector != null) break block18;
                        longBlock2 = this.eval(page.getPositionCount(), valueBlock, chronoFieldBlock);
                        if (chronoFieldBlock == null) break block19;
                        chronoFieldBlock.close();
                    }
                    return longBlock2;
                }
                longBlock = this.eval(page.getPositionCount(), valueVector, chronoFieldVector);
                if (chronoFieldBlock == null) break block20;
                chronoFieldBlock.close();
            }
            return longBlock;
        }
    }

    public LongBlock eval(int positionCount, LongBlock valueBlock, BytesRefBlock chronoFieldBlock) {
        try (LongBlock.Builder result = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            BytesRef chronoFieldScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                if (valueBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (valueBlock.getValueCount(p) != 1) {
                    if (valueBlock.getValueCount(p) > 1) {
                        this.warnings.registerException(new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                if (chronoFieldBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (chronoFieldBlock.getValueCount(p) != 1) {
                    if (chronoFieldBlock.getValueCount(p) > 1) {
                        this.warnings.registerException(new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                try {
                    result.appendLong(DateExtract.process(valueBlock.getLong(valueBlock.getFirstValueIndex(p)), chronoFieldBlock.getBytesRef(chronoFieldBlock.getFirstValueIndex(p), chronoFieldScratch), this.zone));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.warnings.registerException(e);
                    result.appendNull();
                }
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public LongBlock eval(int positionCount, LongVector valueVector, BytesRefVector chronoFieldVector) {
        try (LongBlock.Builder result = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            BytesRef chronoFieldScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                try {
                    result.appendLong(DateExtract.process(valueVector.getLong(p), chronoFieldVector.getBytesRef(p, chronoFieldScratch), this.zone));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.warnings.registerException(e);
                    result.appendNull();
                }
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public String toString() {
        return "DateExtractEvaluator[value=" + this.value + ", chronoField=" + this.chronoField + ", zone=" + this.zone + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.value, this.chronoField});
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory value;
        private final EvalOperator.ExpressionEvaluator.Factory chronoField;
        private final ZoneId zone;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory value, EvalOperator.ExpressionEvaluator.Factory chronoField, ZoneId zone) {
            this.source = source;
            this.value = value;
            this.chronoField = chronoField;
            this.zone = zone;
        }

        public DateExtractEvaluator get(DriverContext context) {
            return new DateExtractEvaluator(this.source, this.value.get(context), this.chronoField.get(context), this.zone, context);
        }

        public String toString() {
            return "DateExtractEvaluator[value=" + this.value + ", chronoField=" + this.chronoField + ", zone=" + this.zone + "]";
        }
    }
}

