/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToInteger;

public final class ToIntegerFromBooleanEvaluator
extends AbstractConvertFunction.AbstractEvaluator {
    public ToIntegerFromBooleanEvaluator(EvalOperator.ExpressionEvaluator field, Source source, DriverContext driverContext) {
        super(driverContext, field, source);
    }

    @Override
    public String name() {
        return "ToIntegerFromBoolean";
    }

    @Override
    public Block evalVector(Vector v) {
        BooleanVector vector = (BooleanVector)v;
        int positionCount = v.getPositionCount();
        if (vector.isConstant()) {
            return this.driverContext.blockFactory().newConstantIntBlockWith(ToIntegerFromBooleanEvaluator.evalValue(vector, 0), positionCount);
        }
        try (IntBlock.Builder builder = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                builder.appendInt(ToIntegerFromBooleanEvaluator.evalValue(vector, p));
            }
            IntBlock intBlock = builder.build();
            return intBlock;
        }
    }

    private static int evalValue(BooleanVector container, int index) {
        boolean value = container.getBoolean(index);
        return ToInteger.fromBoolean(value);
    }

    @Override
    public Block evalBlock(Block b) {
        BooleanBlock block = (BooleanBlock)b;
        int positionCount = block.getPositionCount();
        try (IntBlock.Builder builder = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = block.getValueCount(p);
                int start = block.getFirstValueIndex(p);
                int end = start + valueCount;
                boolean positionOpened = false;
                boolean valuesAppended = false;
                for (int i = start; i < end; ++i) {
                    int value = ToIntegerFromBooleanEvaluator.evalValue(block, i);
                    if (!positionOpened && valueCount > 1) {
                        builder.beginPositionEntry();
                        positionOpened = true;
                    }
                    builder.appendInt(value);
                    valuesAppended = true;
                }
                if (!valuesAppended) {
                    builder.appendNull();
                    continue;
                }
                if (!positionOpened) continue;
                builder.endPositionEntry();
            }
            IntBlock intBlock = builder.build();
            return intBlock;
        }
    }

    private static int evalValue(BooleanBlock container, int index) {
        boolean value = container.getBoolean(index);
        return ToInteger.fromBoolean(value);
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory field;

        public Factory(EvalOperator.ExpressionEvaluator.Factory field, Source source) {
            this.field = field;
            this.source = source;
        }

        public ToIntegerFromBooleanEvaluator get(DriverContext context) {
            return new ToIntegerFromBooleanEvaluator(this.field.get(context), this.source, context);
        }

        public String toString() {
            return "ToIntegerFromBooleanEvaluator[field=" + this.field + "]";
        }
    }
}

