/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDatetimeFromStringEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToLongFromDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToLongFromIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToLongFromUnsignedLongEvaluator;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public class ToDatetime
extends AbstractConvertFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "ToDatetime", ToDatetime::new);
    private static final Map<DataType, AbstractConvertFunction.BuildFactory> EVALUATORS = Map.ofEntries(Map.entry(DataType.DATETIME, (field, source) -> field), Map.entry(DataType.LONG, (field, source) -> field), Map.entry(DataType.KEYWORD, ToDatetimeFromStringEvaluator.Factory::new), Map.entry(DataType.TEXT, ToDatetimeFromStringEvaluator.Factory::new), Map.entry(DataType.DOUBLE, ToLongFromDoubleEvaluator.Factory::new), Map.entry(DataType.UNSIGNED_LONG, ToLongFromUnsignedLongEvaluator.Factory::new), Map.entry(DataType.INTEGER, ToLongFromIntEvaluator.Factory::new));

    @FunctionInfo(returnType={"date"}, description="Converts an input value to a date value.\nA string will only be successfully converted if it's respecting the format `yyyy-MM-dd'T'HH:mm:ss.SSS'Z'`.\nTo convert dates in other formats, use <<esql-date_parse>>.", examples={@Example(file="date", tag="to_datetime-str", explanation="Note that in this example, the last value in the source multi-valued field has not been converted.\nThe reason being that if the date format is not respected, the conversion will result in a *null* value.\nWhen this happens a _Warning_ header is added to the response.\nThe header will provide information on the source of the failure:\n\n`\"Line 1:112: evaluation of [TO_DATETIME(string)] failed, treating result as null. \"Only first 20 failures recorded.\"`\n\nA following header will contain the failure reason and the offending value:\n\n`\"java.lang.IllegalArgumentException: failed to parse date field [1964-06-02 00:00:00]\nwith format [yyyy-MM-dd'T'HH:mm:ss.SSS'Z']\"`\n"), @Example(description="If the input parameter is of a numeric type,\nits value will be interpreted as milliseconds since the {wikipedia}/Unix_time[Unix epoch]. For example:", file="date", tag="to_datetime-int")})
    public ToDatetime(Source source, @Param(name="field", type={"date", "keyword", "text", "double", "long", "unsigned_long", "integer"}, description="Input value. The input can be a single- or multi-valued column or an expression.") Expression field) {
        super(source, field);
    }

    private ToDatetime(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return ToDatetime.ENTRY.name;
    }

    @Override
    protected Map<DataType, AbstractConvertFunction.BuildFactory> factories() {
        return EVALUATORS;
    }

    @Override
    public DataType dataType() {
        return DataType.DATETIME;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new ToDatetime(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, ToDatetime::new, (Object)this.field());
    }

    static long fromKeyword(BytesRef in) {
        return EsqlDataTypeConverter.dateTimeToLong(in.utf8ToString());
    }
}

