/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.conditional;

import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.LeastBooleanEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.LeastBytesRefEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.LeastDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.LeastIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.LeastLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMin;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public class Least
extends EsqlScalarFunction
implements OptionalArgument {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Least", Least::new);
    private DataType dataType;

    @FunctionInfo(returnType={"boolean", "double", "integer", "ip", "keyword", "long", "text", "version"}, description="Returns the minimum value from multiple columns. This is similar to <<esql-mv_min>> except it is intended to run on multiple columns at once.", examples={@Example(file="math", tag="least")})
    public Least(Source source, @Param(name="first", type={"boolean", "double", "integer", "ip", "keyword", "long", "text", "version"}, description="First of the columns to evaluate.") Expression first, @Param(name="rest", type={"boolean", "double", "integer", "ip", "keyword", "long", "text", "version"}, description="The rest of the columns to evaluate.", optional=true) List<Expression> rest) {
        super(source, Stream.concat(Stream.of(first), rest.stream()).toList());
    }

    private Least(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), in.readNamedWriteableCollectionAsList(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.children().get(0));
        out.writeNamedWriteableCollection(this.children().subList(1, this.children().size()));
    }

    public String getWriteableName() {
        return Least.ENTRY.name;
    }

    public DataType dataType() {
        if (this.dataType == null) {
            this.resolveType();
        }
        return this.dataType;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        for (int position = 0; position < this.children().size(); ++position) {
            Expression child = (Expression)this.children().get(position);
            if (this.dataType == null || this.dataType == DataType.NULL) {
                this.dataType = child.dataType();
                continue;
            }
            Expression.TypeResolution resolution = TypeResolutions.isType((Expression)child, t -> t == this.dataType, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.fromIndex((int)position), (String[])new String[]{this.dataType.typeName()});
            if (!resolution.unresolved()) continue;
            return resolution;
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Least(this.source(), newChildren.get(0), newChildren.subList(1, newChildren.size()));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Least::new, (Object)((Expression)this.children().get(0)), this.children().subList(1, this.children().size()));
    }

    public boolean foldable() {
        return Expressions.foldable((List)this.children());
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        DataType dataType = this.dataType();
        EvalOperator.ExpressionEvaluator.Factory[] factories = (EvalOperator.ExpressionEvaluator.Factory[])this.children().stream().map(e -> (EvalOperator.ExpressionEvaluator.Factory)toEvaluator.apply((Expression)new MvMin(e.source(), (Expression)e))).toArray(EvalOperator.ExpressionEvaluator.Factory[]::new);
        if (dataType == DataType.BOOLEAN) {
            return new LeastBooleanEvaluator.Factory(this.source(), factories);
        }
        if (dataType == DataType.DOUBLE) {
            return new LeastDoubleEvaluator.Factory(this.source(), factories);
        }
        if (dataType == DataType.INTEGER) {
            return new LeastIntEvaluator.Factory(this.source(), factories);
        }
        if (dataType == DataType.LONG) {
            return new LeastLongEvaluator.Factory(this.source(), factories);
        }
        if (dataType == DataType.KEYWORD || dataType == DataType.TEXT || dataType == DataType.IP || dataType == DataType.VERSION || dataType == DataType.UNSUPPORTED) {
            return new LeastBytesRefEvaluator.Factory(this.source(), factories);
        }
        throw EsqlIllegalArgumentException.illegalDataType(dataType);
    }

    static boolean process(boolean[] values) {
        for (boolean v : values) {
            if (v) continue;
            return false;
        }
        return true;
    }

    static BytesRef process(BytesRef[] values) {
        BytesRef min = values[0];
        for (int i = 1; i < values.length; ++i) {
            min = min.compareTo(values[i]) < 0 ? min : values[i];
        }
        return min;
    }

    static int process(int[] values) {
        int min = values[0];
        for (int i = 1; i < values.length; ++i) {
            min = Math.min(min, values[i]);
        }
        return min;
    }

    static long process(long[] values) {
        long min = values[0];
        for (int i = 1; i < values.length; ++i) {
            min = Math.min(min, values[i]);
        }
        return min;
    }

    static double process(double[] values) {
        double min = values[0];
        for (int i = 1; i < values.length; ++i) {
            min = Math.min(min, values[i]);
        }
        return min;
    }
}

