/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.conditional;

import java.util.Arrays;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Warnings;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.Greatest;

public final class GreatestDoubleEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Warnings warnings;
    private final EvalOperator.ExpressionEvaluator[] values;
    private final DriverContext driverContext;

    public GreatestDoubleEvaluator(Source source, EvalOperator.ExpressionEvaluator[] values, DriverContext driverContext) {
        this.values = values;
        this.driverContext = driverContext;
        this.warnings = Warnings.createWarnings(driverContext.warningsMode(), source);
    }

    public Block eval(Page page) {
        DoubleBlock[] valuesBlocks = new DoubleBlock[this.values.length];
        try (Releasable valuesRelease = Releasables.wrap((Releasable[])valuesBlocks);){
            for (int i = 0; i < valuesBlocks.length; ++i) {
                valuesBlocks[i] = (DoubleBlock)this.values[i].eval(page);
            }
            DoubleVector[] valuesVectors = new DoubleVector[this.values.length];
            for (int i = 0; i < valuesBlocks.length; ++i) {
                valuesVectors[i] = valuesBlocks[i].asVector();
                if (valuesVectors[i] != null) continue;
                DoubleBlock doubleBlock = this.eval(page.getPositionCount(), valuesBlocks);
                return doubleBlock;
            }
            DoubleBlock doubleBlock = this.eval(page.getPositionCount(), valuesVectors).asBlock();
            return doubleBlock;
        }
    }

    public DoubleBlock eval(int positionCount, DoubleBlock[] valuesBlocks) {
        try (DoubleBlock.Builder result = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            double[] valuesValues = new double[this.values.length];
            block5: for (int p = 0; p < positionCount; ++p) {
                int i;
                for (i = 0; i < valuesBlocks.length; ++i) {
                    if (valuesBlocks[i].isNull(p)) {
                        result.appendNull();
                        continue block5;
                    }
                    if (valuesBlocks[i].getValueCount(p) == 1) continue;
                    if (valuesBlocks[i].getValueCount(p) > 1) {
                        this.warnings.registerException(new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue block5;
                }
                for (i = 0; i < valuesBlocks.length; ++i) {
                    int o = valuesBlocks[i].getFirstValueIndex(p);
                    valuesValues[i] = valuesBlocks[i].getDouble(o);
                }
                result.appendDouble(Greatest.process(valuesValues));
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public DoubleVector eval(int positionCount, DoubleVector[] valuesVectors) {
        try (DoubleVector.FixedBuilder result = this.driverContext.blockFactory().newDoubleVectorFixedBuilder(positionCount);){
            double[] valuesValues = new double[this.values.length];
            for (int p = 0; p < positionCount; ++p) {
                for (int i = 0; i < valuesVectors.length; ++i) {
                    valuesValues[i] = valuesVectors[i].getDouble(p);
                }
                result.appendDouble(p, Greatest.process(valuesValues));
            }
            DoubleVector doubleVector = result.build();
            return doubleVector;
        }
    }

    public String toString() {
        return "GreatestDoubleEvaluator[values=" + Arrays.toString(this.values) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException(() -> Releasables.close((Releasable[])this.values));
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory[] values;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory[] values) {
            this.source = source;
            this.values = values;
        }

        public GreatestDoubleEvaluator get(DriverContext context) {
            EvalOperator.ExpressionEvaluator[] values = (EvalOperator.ExpressionEvaluator[])Arrays.stream(this.values).map(a -> a.get(context)).toArray(EvalOperator.ExpressionEvaluator[]::new);
            return new GreatestDoubleEvaluator(this.source, values, context);
        }

        public String toString() {
            return "GreatestDoubleEvaluator[values=" + Arrays.toString(this.values) + "]";
        }
    }
}

