/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.ValuesBooleanAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.ValuesBytesRefAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.ValuesDoubleAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.ValuesIntAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.ValuesLongAggregatorFunctionSupplier;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.EsqlTypeResolutions;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.planner.ToAggregator;

public class Values
extends AggregateFunction
implements ToAggregator {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Values", Values::new);

    @FunctionInfo(returnType={"boolean|date|double|integer|ip|keyword|long|text|version"}, description="Collect values for a field.", isAggregation=true)
    public Values(Source source, @Param(name="field", type={"boolean|date|double|integer|ip|keyword|long|text|version"}) Expression v) {
        super(source, v);
    }

    private Values(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return Values.ENTRY.name;
    }

    protected NodeInfo<Values> info() {
        return NodeInfo.create((Node)this, Values::new, (Object)this.field());
    }

    public Values replaceChildren(List<Expression> newChildren) {
        return new Values(this.source(), newChildren.get(0));
    }

    public DataType dataType() {
        return this.field().dataType();
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return EsqlTypeResolutions.isNotSpatial(this.field(), this.sourceText(), TypeResolutions.ParamOrdinal.DEFAULT);
    }

    @Override
    public AggregatorFunctionSupplier supplier(List<Integer> inputChannels) {
        DataType type = this.field().dataType();
        if (type == DataType.INTEGER) {
            return new ValuesIntAggregatorFunctionSupplier(inputChannels);
        }
        if (type == DataType.LONG || type == DataType.DATETIME) {
            return new ValuesLongAggregatorFunctionSupplier(inputChannels);
        }
        if (type == DataType.DOUBLE) {
            return new ValuesDoubleAggregatorFunctionSupplier(inputChannels);
        }
        if (DataType.isString((DataType)type) || type == DataType.IP || type == DataType.VERSION) {
            return new ValuesBytesRefAggregatorFunctionSupplier(inputChannels);
        }
        if (type == DataType.BOOLEAN) {
            return new ValuesBooleanAggregatorFunctionSupplier(inputChannels);
        }
        throw EsqlIllegalArgumentException.illegalDataType(type);
    }
}

