/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.TopDoubleAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.TopIntAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.TopLongAggregatorFunctionSupplier;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.SurrogateExpression;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Max;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Min;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.planner.ToAggregator;

public class Top
extends AggregateFunction
implements ToAggregator,
SurrogateExpression {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Top", Top::new);
    private static final String ORDER_ASC = "ASC";
    private static final String ORDER_DESC = "DESC";

    @FunctionInfo(returnType={"double", "integer", "long", "date"}, description="Collects the top values for a field. Includes repeated values.", isAggregation=true, examples={@Example(file="stats_top", tag="top")})
    public Top(Source source, @Param(name="field", type={"double", "integer", "long", "date"}, description="The field to collect the top values for.") Expression field, @Param(name="limit", type={"integer"}, description="The maximum number of values to collect.") Expression limit, @Param(name="order", type={"keyword"}, description="The order to calculate the top values. Either `asc` or `desc`.") Expression order) {
        super(source, field, Arrays.asList(limit, order));
    }

    private Top(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        List fields = this.children();
        assert (fields.size() == 3);
        out.writeNamedWriteable((NamedWriteable)fields.get(0));
        out.writeNamedWriteable((NamedWriteable)fields.get(1));
        out.writeNamedWriteable((NamedWriteable)fields.get(2));
    }

    public String getWriteableName() {
        return Top.ENTRY.name;
    }

    Expression limitField() {
        return this.parameters().get(0);
    }

    Expression orderField() {
        return this.parameters().get(1);
    }

    private int limitValue() {
        return (Integer)this.limitField().fold();
    }

    private String orderRawValue() {
        return BytesRefs.toString((Object)this.orderField().fold());
    }

    private boolean orderValue() {
        return this.orderRawValue().equalsIgnoreCase(ORDER_ASC);
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution typeResolution = TypeResolutions.isType((Expression)this.field(), dt -> dt == DataType.DATETIME || dt.isNumeric() && dt != DataType.UNSIGNED_LONG, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST, (String[])new String[]{"numeric except unsigned_long or counter types"}).and(TypeResolutions.isNotNullAndFoldable((Expression)this.limitField(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND)).and(TypeResolutions.isType((Expression)this.limitField(), dt -> dt == DataType.INTEGER, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND, (String[])new String[]{"integer"})).and(TypeResolutions.isNotNullAndFoldable((Expression)this.orderField(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.THIRD)).and(TypeResolutions.isString((Expression)this.orderField(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.THIRD));
        if (typeResolution.unresolved()) {
            return typeResolution;
        }
        int limit = this.limitValue();
        String order = this.orderRawValue();
        if (limit <= 0) {
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"Limit must be greater than 0 in [{}], found [{}]", (Object[])new Object[]{this.sourceText(), limit}));
        }
        if (!order.equalsIgnoreCase(ORDER_ASC) && !order.equalsIgnoreCase(ORDER_DESC)) {
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"Invalid order value in [{}], expected [{}, {}] but got [{}]", (Object[])new Object[]{this.sourceText(), ORDER_ASC, ORDER_DESC, order}));
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public DataType dataType() {
        return this.field().dataType();
    }

    protected NodeInfo<Top> info() {
        return NodeInfo.create((Node)this, Top::new, (Object)((Expression)this.children().get(0)), (Object)((Expression)this.children().get(1)), (Object)((Expression)this.children().get(2)));
    }

    public Top replaceChildren(List<Expression> newChildren) {
        return new Top(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2));
    }

    @Override
    public AggregatorFunctionSupplier supplier(List<Integer> inputChannels) {
        DataType type = this.field().dataType();
        if (type == DataType.LONG || type == DataType.DATETIME) {
            return new TopLongAggregatorFunctionSupplier(inputChannels, this.limitValue(), this.orderValue());
        }
        if (type == DataType.INTEGER) {
            return new TopIntAggregatorFunctionSupplier(inputChannels, this.limitValue(), this.orderValue());
        }
        if (type == DataType.DOUBLE) {
            return new TopDoubleAggregatorFunctionSupplier(inputChannels, this.limitValue(), this.orderValue());
        }
        throw EsqlIllegalArgumentException.illegalDataType(type);
    }

    @Override
    public Expression surrogate() {
        Source s = this.source();
        if (this.limitValue() == 1) {
            if (this.orderValue()) {
                return new Min(s, this.field());
            }
            return new Max(s, this.field());
        }
        return null;
    }
}

