/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.List;
import java.util.stream.IntStream;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.aggregation.Aggregator;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.AggregatorMode;
import org.elasticsearch.compute.aggregation.GroupingAggregator;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.ToPartialAggregatorFunction;
import org.elasticsearch.compute.aggregation.ToPartialGroupingAggregatorFunction;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.planner.ToAggregator;

public class ToPartial
extends AggregateFunction
implements ToAggregator {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "ToPartial", ToPartial::new);
    private final Expression function;

    public ToPartial(Source source, Expression field, Expression function) {
        super(source, field, List.of(function));
        this.function = function;
    }

    private ToPartial(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.field());
        out.writeNamedWriteable((NamedWriteable)this.function);
    }

    public String getWriteableName() {
        return ToPartial.ENTRY.name;
    }

    public Expression function() {
        return this.function;
    }

    public DataType dataType() {
        return DataType.PARTIAL_AGG;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return this.function.typeResolved();
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new ToPartial(this.source(), newChildren.get(0), newChildren.get(1));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, ToPartial::new, (Object)this.field(), (Object)this.function);
    }

    @Override
    public AggregatorFunctionSupplier supplier(final List<Integer> inputChannels) {
        final ToAggregator toAggregator = (ToAggregator)this.function;
        return new AggregatorFunctionSupplier(){

            public AggregatorFunction aggregator(DriverContext driverContext) {
                assert (false) : "aggregatorFactory() is override";
                throw new UnsupportedOperationException();
            }

            public GroupingAggregatorFunction groupingAggregator(DriverContext driverContext) {
                assert (false) : "groupingAggregatorFactory() is override";
                throw new UnsupportedOperationException();
            }

            public Aggregator.Factory aggregatorFactory(final AggregatorMode mode) {
                AggregatorFunctionSupplier supplier;
                if (mode.isInputPartial()) {
                    try (AggregatorFunction dummy = toAggregator.supplier(inputChannels).aggregator(DriverContext.getLocalDriver());){
                        List<Integer> intermediateChannels = IntStream.range(0, dummy.intermediateBlockCount()).boxed().toList();
                        supplier = toAggregator.supplier(intermediateChannels);
                    }
                } else {
                    supplier = toAggregator.supplier(inputChannels);
                }
                return new Aggregator.Factory(){

                    public Aggregator apply(DriverContext driverContext) {
                        AggregatorFunction aggregatorFunction = supplier.aggregator(driverContext);
                        return new Aggregator((AggregatorFunction)new ToPartialAggregatorFunction(aggregatorFunction, inputChannels), mode);
                    }

                    public String describe() {
                        return "to_partial(" + supplier.describe() + ")";
                    }
                };
            }

            public GroupingAggregator.Factory groupingAggregatorFactory(final AggregatorMode mode) {
                AggregatorFunctionSupplier supplier;
                if (mode.isInputPartial()) {
                    try (AggregatorFunction dummy = toAggregator.supplier(inputChannels).aggregator(DriverContext.getLocalDriver());){
                        List<Integer> intermediateChannels = IntStream.range(0, dummy.intermediateBlockCount()).boxed().toList();
                        supplier = toAggregator.supplier(intermediateChannels);
                    }
                } else {
                    supplier = toAggregator.supplier(inputChannels);
                }
                return new GroupingAggregator.Factory(){

                    public GroupingAggregator apply(DriverContext driverContext) {
                        GroupingAggregatorFunction aggregatorFunction = supplier.groupingAggregator(driverContext);
                        return new GroupingAggregator((GroupingAggregatorFunction)new ToPartialGroupingAggregatorFunction(aggregatorFunction, inputChannels), mode);
                    }

                    public String describe() {
                        return "to_partial(" + supplier.describe() + ")";
                    }
                };
            }

            public String describe() {
                return "to_partial";
            }
        };
    }
}

