/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.SumDoubleAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.SumIntAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.SumLongAggregatorFunctionSupplier;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.SurrogateExpression;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Count;
import org.elasticsearch.xpack.esql.expression.function.aggregate.NumericAggregate;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvSum;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Mul;

public class Sum
extends NumericAggregate
implements SurrogateExpression {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Sum", Sum::new);

    @FunctionInfo(returnType={"long"}, description="The sum of a numeric field.", isAggregation=true)
    public Sum(Source source, @Param(name="number", type={"double", "integer", "long"}) Expression field) {
        super(source, field);
    }

    private Sum(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return Sum.ENTRY.name;
    }

    protected NodeInfo<Sum> info() {
        return NodeInfo.create((Node)this, Sum::new, (Object)this.field());
    }

    public Sum replaceChildren(List<Expression> newChildren) {
        return new Sum(this.source(), newChildren.get(0));
    }

    @Override
    public DataType dataType() {
        DataType dt = this.field().dataType();
        return !dt.isWholeNumber() || dt == DataType.UNSIGNED_LONG ? DataType.DOUBLE : DataType.LONG;
    }

    @Override
    protected AggregatorFunctionSupplier longSupplier(List<Integer> inputChannels) {
        return new SumLongAggregatorFunctionSupplier(inputChannels);
    }

    @Override
    protected AggregatorFunctionSupplier intSupplier(List<Integer> inputChannels) {
        return new SumIntAggregatorFunctionSupplier(inputChannels);
    }

    @Override
    protected AggregatorFunctionSupplier doubleSupplier(List<Integer> inputChannels) {
        return new SumDoubleAggregatorFunctionSupplier(inputChannels);
    }

    @Override
    public Expression surrogate() {
        Source s = this.source();
        Expression field = this.field();
        return field.foldable() ? new Mul(s, (Expression)new MvSum(s, field), (Expression)new Count(s, (Expression)new Literal(s, (Object)"*", DataType.KEYWORD))) : null;
    }
}

