/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.PercentileDoubleAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.PercentileIntAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.PercentileLongAggregatorFunctionSupplier;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.NumericAggregate;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public class Percentile
extends NumericAggregate {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Percentile", Percentile::new);
    private final Expression percentile;

    @FunctionInfo(returnType={"double", "integer", "long"}, description="The value at which a certain percentage of observed values occur.", isAggregation=true)
    public Percentile(Source source, @Param(name="number", type={"double", "integer", "long"}) Expression field, @Param(name="percentile", type={"double", "integer", "long"}) Expression percentile) {
        super(source, field, List.of(percentile));
        this.percentile = percentile;
    }

    private Percentile(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.children().get(0));
        out.writeNamedWriteable((NamedWriteable)this.children().get(1));
    }

    public String getWriteableName() {
        return Percentile.ENTRY.name;
    }

    protected NodeInfo<Percentile> info() {
        return NodeInfo.create((Node)this, Percentile::new, (Object)this.field(), (Object)this.percentile);
    }

    public Percentile replaceChildren(List<Expression> newChildren) {
        return new Percentile(this.source(), newChildren.get(0), newChildren.get(1));
    }

    public Expression percentile() {
        return this.percentile;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isType((Expression)this.field(), dt -> dt.isNumeric() && dt != DataType.UNSIGNED_LONG, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST, (String[])new String[]{"numeric except unsigned_long"});
        if (resolution.unresolved()) {
            return resolution;
        }
        return TypeResolutions.isNumeric((Expression)this.percentile, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND).and(TypeResolutions.isFoldable((Expression)this.percentile, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND));
    }

    @Override
    protected AggregatorFunctionSupplier longSupplier(List<Integer> inputChannels) {
        return new PercentileLongAggregatorFunctionSupplier(inputChannels, (double)this.percentileValue());
    }

    @Override
    protected AggregatorFunctionSupplier intSupplier(List<Integer> inputChannels) {
        return new PercentileIntAggregatorFunctionSupplier(inputChannels, (double)this.percentileValue());
    }

    @Override
    protected AggregatorFunctionSupplier doubleSupplier(List<Integer> inputChannels) {
        return new PercentileDoubleAggregatorFunctionSupplier(inputChannels, (double)this.percentileValue());
    }

    private int percentileValue() {
        return ((Number)this.percentile.fold()).intValue();
    }
}

