/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.planner.ToAggregator;

public abstract class NumericAggregate
extends AggregateFunction
implements ToAggregator {
    NumericAggregate(Source source, Expression field, List<Expression> parameters) {
        super(source, field, parameters);
    }

    NumericAggregate(Source source, Expression field) {
        super(source, field);
    }

    NumericAggregate(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (this.supportsDates()) {
            return TypeResolutions.isType((Expression)this, e -> e == DataType.DATETIME || e.isNumeric() && e != DataType.UNSIGNED_LONG, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT, (String[])new String[]{"datetime", "numeric except unsigned_long or counter types"});
        }
        return TypeResolutions.isType((Expression)this.field(), dt -> dt.isNumeric() && dt != DataType.UNSIGNED_LONG, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT, (String[])new String[]{"numeric except unsigned_long or counter types"});
    }

    protected boolean supportsDates() {
        return false;
    }

    public DataType dataType() {
        return DataType.DOUBLE;
    }

    @Override
    public final AggregatorFunctionSupplier supplier(List<Integer> inputChannels) {
        DataType type = this.field().dataType();
        if (this.supportsDates() && type == DataType.DATETIME) {
            return this.longSupplier(inputChannels);
        }
        if (type == DataType.LONG) {
            return this.longSupplier(inputChannels);
        }
        if (type == DataType.INTEGER) {
            return this.intSupplier(inputChannels);
        }
        if (type == DataType.DOUBLE) {
            return this.doubleSupplier(inputChannels);
        }
        throw EsqlIllegalArgumentException.illegalDataType(type);
    }

    protected abstract AggregatorFunctionSupplier longSupplier(List<Integer> var1);

    protected abstract AggregatorFunctionSupplier intSupplier(List<Integer> var1);

    protected abstract AggregatorFunctionSupplier doubleSupplier(List<Integer> var1);
}

