/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.CountAggregatorFunction;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.SurrogateExpression;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.expression.function.aggregate.EnclosedAgg;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvCount;
import org.elasticsearch.xpack.esql.expression.function.scalar.nulls.Coalesce;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Mul;
import org.elasticsearch.xpack.esql.planner.ToAggregator;

public class Count
extends AggregateFunction
implements EnclosedAgg,
ToAggregator,
SurrogateExpression {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Count", Count::new);

    @FunctionInfo(returnType={"long"}, description="Returns the total number (count) of input values.", isAggregation=true)
    public Count(Source source, @Param(optional=true, name="field", type={"boolean", "cartesian_point", "date", "double", "geo_point", "integer", "ip", "keyword", "long", "text", "unsigned_long", "version"}, description="Column or literal for which to count the number of values.") Expression field) {
        super(source, field);
    }

    private Count(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return Count.ENTRY.name;
    }

    protected NodeInfo<Count> info() {
        return NodeInfo.create((Node)this, Count::new, (Object)this.field());
    }

    public Count replaceChildren(List<Expression> newChildren) {
        return new Count(this.source(), newChildren.get(0));
    }

    @Override
    public String innerName() {
        return "count";
    }

    public DataType dataType() {
        return DataType.LONG;
    }

    @Override
    public AggregatorFunctionSupplier supplier(List<Integer> inputChannels) {
        return CountAggregatorFunction.supplier(inputChannels);
    }

    public Nullability nullable() {
        return Nullability.FALSE;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isType((Expression)this.field(), dt -> !dt.isCounter(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT, (String[])new String[]{"any type except counter types"});
    }

    @Override
    public Expression surrogate() {
        Source s = this.source();
        Expression field = this.field();
        if (field.foldable()) {
            Literal l;
            if (field instanceof Literal && (l = (Literal)field).value() != null && !(l.value() instanceof List)) {
                return null;
            }
            return new Mul(s, (Expression)new Coalesce(s, (Expression)new MvCount(s, field), List.of(new Literal(s, (Object)0, DataType.INTEGER))), (Expression)new Count(s, (Expression)new Literal(s, (Object)"*", DataType.KEYWORD)));
        }
        return null;
    }
}

