/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.expression.function.Function;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.util.CollectionUtils;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Avg;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Count;
import org.elasticsearch.xpack.esql.expression.function.aggregate.CountDistinct;
import org.elasticsearch.xpack.esql.expression.function.aggregate.FromPartial;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Max;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Median;
import org.elasticsearch.xpack.esql.expression.function.aggregate.MedianAbsoluteDeviation;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Min;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Percentile;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Rate;
import org.elasticsearch.xpack.esql.expression.function.aggregate.SpatialCentroid;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Sum;
import org.elasticsearch.xpack.esql.expression.function.aggregate.ToPartial;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Top;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Values;
import org.elasticsearch.xpack.esql.expression.function.aggregate.WeightedAvg;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public abstract class AggregateFunction
extends Function {
    private final Expression field;
    private final List<? extends Expression> parameters;

    public static List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return List.of(Avg.ENTRY, Count.ENTRY, CountDistinct.ENTRY, Max.ENTRY, Median.ENTRY, MedianAbsoluteDeviation.ENTRY, Min.ENTRY, Percentile.ENTRY, Rate.ENTRY, SpatialCentroid.ENTRY, Sum.ENTRY, Top.ENTRY, Values.ENTRY, ToPartial.ENTRY, FromPartial.ENTRY, WeightedAvg.ENTRY);
    }

    protected AggregateFunction(Source source, Expression field) {
        this(source, field, Collections.emptyList());
    }

    protected AggregateFunction(Source source, Expression field, List<? extends Expression> parameters) {
        super(source, CollectionUtils.combine(Collections.singletonList(field), parameters));
        this.field = field;
        this.parameters = parameters;
    }

    protected AggregateFunction(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.field);
    }

    public Expression field() {
        return this.field;
    }

    public List<? extends Expression> parameters() {
        return this.parameters;
    }

    public List<Expression> inputExpressions() {
        return List.of(this.field);
    }

    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isExact((Expression)this.field, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT);
    }

    public int hashCode() {
        return Objects.hash(((Object)((Object)this)).getClass(), this.children());
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            AggregateFunction other = (AggregateFunction)((Object)obj);
            return Objects.equals(other.field(), this.field()) && Objects.equals(other.parameters(), this.parameters());
        }
        return false;
    }
}

