/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function;

import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.xpack.esql.core.tree.Source;

public class Warnings {
    static final int MAX_ADDED_WARNINGS = 20;
    private final String location;
    private final String first;
    private int addedWarnings;
    public static final Warnings NOOP_WARNINGS = new Warnings(Source.EMPTY){

        @Override
        public void registerException(Exception exception) {
        }
    };

    public static Warnings createWarnings(DriverContext.WarningsMode warningsMode, Source source) {
        switch (warningsMode) {
            case COLLECT: {
                return new Warnings(source);
            }
            case IGNORE: {
                return NOOP_WARNINGS;
            }
        }
        throw new IllegalStateException("Unreachable");
    }

    public Warnings(Source source) {
        this.location = LoggerMessageFormat.format((String)"Line {}:{}: ", (Object[])new Object[]{source.source().getLineNumber(), source.source().getColumnNumber()});
        this.first = LoggerMessageFormat.format(null, (String)"{}evaluation of [{}] failed, treating result as null. Only first {} failures recorded.", (Object[])new Object[]{this.location, source.text(), 20});
    }

    public void registerException(Exception exception) {
        if (this.addedWarnings < 20) {
            if (this.addedWarnings == 0) {
                HeaderWarning.addWarning((String)this.first, (Object[])new Object[0]);
            }
            HeaderWarning.addWarning((String)(this.location + exception.getClass().getName() + ": " + exception.getMessage()), (Object[])new Object[0]);
            ++this.addedWarnings;
        }
    }
}

