/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.capabilities.Unresolvable;
import org.elasticsearch.xpack.esql.core.capabilities.UnresolvedException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.function.Function;
import org.elasticsearch.xpack.esql.core.session.Configuration;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.StringUtils;
import org.elasticsearch.xpack.esql.expression.function.FunctionDefinition;
import org.elasticsearch.xpack.esql.expression.function.FunctionResolutionStrategy;

public class UnresolvedFunction
extends Function
implements Unresolvable {
    private final String name;
    private final String unresolvedMsg;
    private final FunctionResolutionStrategy resolution;
    private final boolean analyzed;

    public UnresolvedFunction(Source source, String name, FunctionResolutionStrategy resolutionStrategy, List<Expression> children) {
        this(source, name, resolutionStrategy, children, false, null);
    }

    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getWriteableName() {
        throw new UnsupportedOperationException();
    }

    public UnresolvedFunction(Source source, String name, FunctionResolutionStrategy resolutionStrategy, List<Expression> children, boolean analyzed, String unresolvedMessage) {
        super(source, children);
        this.name = name;
        this.resolution = resolutionStrategy;
        this.analyzed = analyzed;
        this.unresolvedMsg = unresolvedMessage == null ? "Unknown " + resolutionStrategy.kind() + " [" + name + "]" : unresolvedMessage;
    }

    protected NodeInfo<UnresolvedFunction> info() {
        return NodeInfo.create((Node)this, UnresolvedFunction::new, (Object)this.name, (Object)this.resolution, (Object)this.children(), (Object)this.analyzed, (Object)this.unresolvedMsg);
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new UnresolvedFunction(this.source(), this.name, this.resolution, newChildren, this.analyzed, this.unresolvedMsg);
    }

    public UnresolvedFunction withMessage(String message) {
        return new UnresolvedFunction(this.source(), this.name(), this.resolution, this.children(), true, message);
    }

    public Function buildResolved(Configuration configuration, FunctionDefinition def) {
        return this.resolution.buildResolved(this, configuration, def);
    }

    public UnresolvedFunction missing(String normalizedName, Iterable<FunctionDefinition> alternatives) {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (FunctionDefinition def : alternatives) {
            if (!this.resolution.isValidAlternative(def)) continue;
            names.add(def.name());
            names.addAll(def.aliases());
        }
        List matches = StringUtils.findSimilar((String)normalizedName, names);
        if (matches.isEmpty()) {
            return this;
        }
        String matchesMessage = matches.size() == 1 ? "[" + (String)matches.get(0) + "]" : "any of " + matches;
        return this.withMessage("Unknown " + this.resolution.kind() + " [" + this.name + "], did you mean " + matchesMessage + "?");
    }

    public boolean resolved() {
        return false;
    }

    public String name() {
        return this.name;
    }

    public FunctionResolutionStrategy resolutionStrategy() {
        return this.resolution;
    }

    public boolean analyzed() {
        return this.analyzed;
    }

    public DataType dataType() {
        throw new UnresolvedException("dataType", (Object)this);
    }

    public Nullability nullable() {
        throw new UnresolvedException("nullable", (Object)this);
    }

    public String unresolvedMessage() {
        return this.unresolvedMsg;
    }

    public String toString() {
        return "?" + this.name + this.children();
    }

    public String nodeString() {
        return this.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        UnresolvedFunction other = (UnresolvedFunction)((Object)obj);
        return this.name.equals(other.name) && this.resolution.equals(other.resolution) && this.children().equals(other.children()) && this.analyzed == other.analyzed && Objects.equals(this.unresolvedMsg, other.unresolvedMsg);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.resolution, this.children(), this.analyzed, this.unresolvedMsg);
    }
}

