/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function;

import java.util.List;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.esql.core.expression.function.Function;
import org.elasticsearch.xpack.esql.core.session.Configuration;
import org.elasticsearch.xpack.esql.expression.function.UnresolvedFunction;

public class FunctionDefinition {
    private final String name;
    private final List<String> aliases;
    private final Class<? extends Function> clazz;
    private final Builder builder;

    public FunctionDefinition(String name, List<String> aliases, Class<? extends Function> clazz, Builder builder) {
        this.name = name;
        this.aliases = aliases;
        this.clazz = clazz;
        this.builder = builder;
    }

    public String name() {
        return this.name;
    }

    public List<String> aliases() {
        return this.aliases;
    }

    public Class<? extends Function> clazz() {
        return this.clazz;
    }

    public Builder builder() {
        return this.builder;
    }

    public String toString() {
        return LoggerMessageFormat.format(null, (String)"{}({})", (Object[])new Object[]{this.name, this.aliases.isEmpty() ? "" : (this.aliases.size() == 1 ? this.aliases.get(0) : this.aliases)});
    }

    @FunctionalInterface
    public static interface Builder {
        public Function build(UnresolvedFunction var1, Configuration var2, Object ... var3);
    }
}

