/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.enrich;

import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.enrich.EnrichResultBuilder;

final class MergePositionsOperator
implements Operator {
    private boolean finished = false;
    private final int positionChannel;
    private final EnrichResultBuilder[] builders;
    private final IntBlock selectedPositions;
    private Page outputPage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MergePositionsOperator(int positionChannel, int[] mergingChannels, ElementType[] mergingTypes, IntBlock selectedPositions, BlockFactory blockFactory) {
        if (mergingChannels.length != mergingTypes.length) {
            throw new IllegalArgumentException("Merging channels don't match merging types; channels=" + Arrays.toString(mergingChannels) + ",types=" + Arrays.toString(mergingTypes));
        }
        this.positionChannel = positionChannel;
        this.builders = new EnrichResultBuilder[mergingTypes.length];
        try {
            for (int i = 0; i < mergingTypes.length; ++i) {
                this.builders[i] = EnrichResultBuilder.enrichResultBuilder(mergingTypes[i], blockFactory, mergingChannels[i]);
            }
        }
        finally {
            if (this.builders[this.builders.length - 1] == null) {
                Releasables.close((Releasable)Releasables.wrap((Releasable[])this.builders));
            }
        }
        selectedPositions.mustIncRef();
        this.selectedPositions = selectedPositions;
    }

    public boolean needsInput() {
        return !this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInput(Page page) {
        try {
            IntBlock positions = (IntBlock)page.getBlock(this.positionChannel);
            IntVector positionsVector = Objects.requireNonNull(positions.asVector(), "positions must be a vector");
            for (EnrichResultBuilder builder : this.builders) {
                builder.addInputPage(positionsVector, page);
            }
        }
        catch (Throwable throwable) {
            Releasables.closeExpectNoException(() -> ((Page)page).releaseBlocks());
            throw throwable;
        }
        Releasables.closeExpectNoException(() -> ((Page)page).releaseBlocks());
    }

    public void finish() {
        Block[] blocks = new Block[this.builders.length];
        try {
            for (int i = 0; i < this.builders.length; ++i) {
                blocks[i] = this.builders[i].build(this.selectedPositions);
            }
            this.outputPage = new Page(blocks);
        }
        finally {
            this.finished = true;
            if (this.outputPage == null) {
                Releasables.close((Releasable[])blocks);
            }
        }
    }

    public boolean isFinished() {
        return this.finished && this.outputPage == null;
    }

    public Page getOutput() {
        Page page = this.outputPage;
        this.outputPage = null;
        return page;
    }

    public void close() {
        Releasables.close((Releasable[])new Releasable[]{Releasables.wrap((Releasable[])this.builders), this.selectedPositions, () -> {
            if (this.outputPage != null) {
                this.outputPage.releaseBlocks();
            }
        }});
    }
}

