/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.action;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.lucene.UnsupportedValueSource;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.action.ColumnInfoImpl;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.NumericUtils;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public final class ResponseValueUtils {
    public static Iterator<Iterator<Object>> pagesToValues(List<DataType> dataTypes, List<Page> pages) {
        BytesRef scratch = new BytesRef();
        return Iterators.flatMap(pages.iterator(), page -> Iterators.forRange((int)0, (int)page.getPositionCount(), pos -> Iterators.forRange((int)0, (int)page.getBlockCount(), b -> ResponseValueUtils.valueAtPosition(page.getBlock(b), pos, (DataType)dataTypes.get(b), scratch))));
    }

    static Iterable<Iterable<Object>> valuesForRowsInPages(List<DataType> dataTypes, List<Page> pages) {
        BytesRef scratch = new BytesRef();
        return () -> Iterators.flatMap(pages.iterator(), page -> ResponseValueUtils.valuesForRowsInPage(dataTypes, page, scratch));
    }

    static Iterator<Iterable<Object>> valuesForRowsInPage(List<DataType> dataTypes, Page page, BytesRef scratch) {
        return Iterators.forRange((int)0, (int)page.getPositionCount(), position -> ResponseValueUtils.valuesForRow(dataTypes, page, position, scratch));
    }

    static Iterable<Object> valuesForRow(List<DataType> dataTypes, Page page, int position, BytesRef scratch) {
        return () -> Iterators.forRange((int)0, (int)page.getBlockCount(), blockIdx -> ResponseValueUtils.valueAtPosition(page.getBlock(blockIdx), position, (DataType)dataTypes.get(blockIdx), scratch));
    }

    static Iterator<Object> valuesForColumn(int columnIndex, DataType dataType, List<Page> pages) {
        BytesRef scratch = new BytesRef();
        return Iterators.flatMap(pages.iterator(), page -> Iterators.forRange((int)0, (int)page.getPositionCount(), pos -> ResponseValueUtils.valueAtPosition(page.getBlock(columnIndex), pos, dataType, scratch)));
    }

    static Object valueAtPosition(Block block, int position, DataType dataType, BytesRef scratch) {
        if (block.isNull(position)) {
            return null;
        }
        int count = block.getValueCount(position);
        int start = block.getFirstValueIndex(position);
        if (count == 1) {
            return ResponseValueUtils.valueAt(dataType, block, start, scratch);
        }
        ArrayList<Object> values = new ArrayList<Object>(count);
        int end = count + start;
        for (int i = start; i < end; ++i) {
            values.add(ResponseValueUtils.valueAt(dataType, block, i, scratch));
        }
        return values;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object valueAt(DataType dataType, Block block, int offset, BytesRef scratch) {
        switch (dataType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case UNSIGNED_LONG: {
                Number number = NumericUtils.unsignedLongAsNumber((long)((LongBlock)block).getLong(offset));
                Object object = number;
                return object;
            }
            case LONG: 
            case COUNTER_LONG: {
                Long l = ((LongBlock)block).getLong(offset);
                Object object = l;
                return object;
            }
            case INTEGER: 
            case COUNTER_INTEGER: {
                Integer n = ((IntBlock)block).getInt(offset);
                Object object = n;
                return object;
            }
            case DOUBLE: 
            case COUNTER_DOUBLE: {
                Double d = ((DoubleBlock)block).getDouble(offset);
                Object object = d;
                return object;
            }
            case KEYWORD: 
            case TEXT: {
                String string = ((BytesRefBlock)block).getBytesRef(offset, scratch).utf8ToString();
                Object object = string;
                return object;
            }
            case IP: {
                BytesRef val = ((BytesRefBlock)block).getBytesRef(offset, scratch);
                String string = EsqlDataTypeConverter.ipToString(val);
                Object object = string;
                return object;
            }
            case DATETIME: {
                long longVal = ((LongBlock)block).getLong(offset);
                String string = EsqlDataTypeConverter.dateTimeToString(longVal);
                Object object = string;
                return object;
            }
            case BOOLEAN: {
                Boolean bl = ((BooleanBlock)block).getBoolean(offset);
                Object object = bl;
                return object;
            }
            case VERSION: {
                String string = EsqlDataTypeConverter.versionToString(((BytesRefBlock)block).getBytesRef(offset, scratch));
                Object object = string;
                return object;
            }
            case GEO_POINT: 
            case GEO_SHAPE: 
            case CARTESIAN_POINT: 
            case CARTESIAN_SHAPE: {
                String string = EsqlDataTypeConverter.spatialToString(((BytesRefBlock)block).getBytesRef(offset, scratch));
                Object object = string;
                return object;
            }
            case UNSUPPORTED: {
                String string = UnsupportedValueSource.UNSUPPORTED_OUTPUT;
                Object object = string;
                return object;
            }
            case SOURCE: {
                Object object;
                BytesRef val = ((BytesRefBlock)block).getBytesRef(offset, scratch);
                try (XContentParser parser = XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)new BytesArray(val));){
                    parser.nextToken();
                    Map map = parser.mapOrdered();
                    object = map;
                    return object;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            case SHORT: 
            case BYTE: 
            case FLOAT: 
            case HALF_FLOAT: 
            case SCALED_FLOAT: 
            case OBJECT: 
            case NESTED: 
            case DATE_PERIOD: 
            case TIME_DURATION: 
            case DOC_DATA_TYPE: 
            case TSID_DATA_TYPE: 
            case NULL: 
            case PARTIAL_AGG: 
        }
        throw EsqlIllegalArgumentException.illegalDataType(dataType);
    }

    static Page valuesToPage(BlockFactory blockFactory, List<ColumnInfoImpl> columns, List<List<Object>> values) {
        List<DataType> dataTypes = columns.stream().map(ColumnInfoImpl::type).toList();
        List<Block.Builder> results = dataTypes.stream().map(c -> PlannerUtils.toElementType(c).newBlockBuilder(values.size(), blockFactory)).toList();
        for (List<Object> row : values) {
            block22: for (int c2 = 0; c2 < row.size(); ++c2) {
                Block.Builder builder = results.get(c2);
                Object value = row.get(c2);
                switch (dataTypes.get(c2)) {
                    case UNSIGNED_LONG: {
                        ((LongBlock.Builder)builder).appendLong(EsqlDataTypeConverter.longToUnsignedLong(((Number)value).longValue(), true));
                        continue block22;
                    }
                    case LONG: 
                    case COUNTER_LONG: {
                        ((LongBlock.Builder)builder).appendLong(((Number)value).longValue());
                        continue block22;
                    }
                    case INTEGER: 
                    case COUNTER_INTEGER: {
                        ((IntBlock.Builder)builder).appendInt(((Number)value).intValue());
                        continue block22;
                    }
                    case DOUBLE: 
                    case COUNTER_DOUBLE: {
                        ((DoubleBlock.Builder)builder).appendDouble(((Number)value).doubleValue());
                        continue block22;
                    }
                    case KEYWORD: 
                    case TEXT: 
                    case UNSUPPORTED: {
                        ((BytesRefBlock.Builder)builder).appendBytesRef(new BytesRef((CharSequence)value.toString()));
                        continue block22;
                    }
                    case IP: {
                        ((BytesRefBlock.Builder)builder).appendBytesRef(EsqlDataTypeConverter.stringToIP(value.toString()));
                        continue block22;
                    }
                    case DATETIME: {
                        long longVal = EsqlDataTypeConverter.dateTimeToLong(value.toString());
                        ((LongBlock.Builder)builder).appendLong(longVal);
                        continue block22;
                    }
                    case BOOLEAN: {
                        ((BooleanBlock.Builder)builder).appendBoolean(((Boolean)value).booleanValue());
                        continue block22;
                    }
                    case NULL: {
                        builder.appendNull();
                        continue block22;
                    }
                    case VERSION: {
                        ((BytesRefBlock.Builder)builder).appendBytesRef(EsqlDataTypeConverter.stringToVersion(new BytesRef((CharSequence)value.toString())));
                        continue block22;
                    }
                    case SOURCE: {
                        Map o = (Map)value;
                        try (XContentBuilder sourceBuilder = JsonXContent.contentBuilder();){
                            sourceBuilder.map(o);
                            ((BytesRefBlock.Builder)builder).appendBytesRef(BytesReference.bytes((XContentBuilder)sourceBuilder).toBytesRef());
                            continue block22;
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                    case GEO_POINT: 
                    case GEO_SHAPE: 
                    case CARTESIAN_POINT: 
                    case CARTESIAN_SHAPE: {
                        BytesRef wkb = EsqlDataTypeConverter.stringToSpatial(value.toString());
                        ((BytesRefBlock.Builder)builder).appendBytesRef(wkb);
                    }
                }
            }
        }
        return new Page((Block[])results.stream().map(Block.Builder::build).toArray(Block[]::new));
    }
}

